% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_treeqsm.R
\name{import_treeqsm}
\alias{import_treeqsm}
\title{Import TreeQSM}
\usage{
import_treeqsm(filename, version = "2.x.x")
}
\arguments{
\item{filename}{a TreeQSM .mat MATLAB file}

\item{version}{TreeQSM version. Valid versions include \verb{2.3.0} - \verb{2.4.1} and
\code{2.0}. Defaults to the most recent format of \verb{2.x.x}.}
}
\value{
Returns a list
}
\description{
Imports a QSM created by TreeQSM
}
\examples{

## Read a TreeQSM MATLAB file in the 2.3.x - 2.4.x format
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_treeqsm(file, version = "2.x.x")
summary(qsm)

## Read a TreeQSM MATLAB file in the 2.0 format
file <- system.file("extdata/QSM_2.mat", package = "rTwig")
qsm <- import_treeqsm(file, version = "2.0")
names(qsm)

}
\references{
\insertRef{TreeQSM}{rTwig}
}
