% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_activity_streams.R
\name{compile_activity_streams}
\alias{compile_activity_streams}
\title{Convert a set of streams of a single activity into a dataframe}
\usage{
compile_activity_streams(streams, id = NULL)
}
\arguments{
\item{streams}{a list containing details of the Strava streams of a single activity (output of \code{\link{get_streams}})}

\item{id}{if not missing, the activity id of the stream (will be appended to the data.frame, if non-empty), as character vector}
}
\value{
data frame where every column is the stream data for the retrieved types.
}
\description{
Convert a set of streams of a single activity into a dataframe, with the retrieved columns.
}
\details{
used internally in \code{\link{get_activity_streams}}
}
\examples{
\dontrun{
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))

act_id <- '351217692'
streams <- get_streams(stoken, id = act_id, types = list('distance', 'latlng'))

compile_activity_streams(streams, id = act_id)
}
}
\author{
Lorenzo Gaborini
}
\concept{token}
