% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_getAllInstruments}
\alias{rp_getAllInstruments}
\title{Get All Instruments}
\usage{
rp_getAllInstruments(
  typeFilter = NULL,
  tradingFilter = NULL,
  fractionalTradingFilter = NULL,
  optionTradingFilter = NULL,
  optionSpreadTradingFilter = NULL
)
}
\arguments{
\item{typeFilter}{= (Optional) Ex. "BOND","EQUITY","CRYPTO","INDEX","ALT"}

\item{tradingFilter}{= (Optional) Ex. "BUY_AND_SELL","DISABLED","LIQUIDATION_ONLY"}

\item{fractionalTradingFilter}{= (Optional) Ex. "DISABLED","BUY_AND_SELL","LIQUIDATION_ONLY"}

\item{optionTradingFilter}{= (Optional) Ex. "DISABLED","BUY_AND_SELL","LIQUIDATION_ONLY"}

\item{optionSpreadTradingFilter}{= (Optional) Ex. "DISABLED","BUY_AND_SELL","LIQUIDATION_ONLY"}
}
\value{
Retrieves all available trading instruments with optional filtering capabilities as a \code{data.frame}.
}
\description{
Get All Instruments
}
\examples{
\dontrun{
  # Fetches All Instruments From Public
    all_inst <- rp_getAllInstruments()
    
    # Fetches All equities enabled for trading fractional shares
    all_frac <- rp_getAllInstruments(typeFilter = "EQUITY", 
                                     tradingFilter = 'BUY_AND_SELL',
                                     fractionalTradingFilter = 'BUY_AND_SELL')
}
}
