% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{download_data}
\alias{download_data}
\title{Download ERA5-Land Data}
\usage{
download_data(
  start_year,
  end_year,
  start_month = 1,
  end_month = 12,
  variables = c("10m_u_component_of_wind", "10m_v_component_of_wind", "2m_temperature",
    "total_precipitation"),
  dataset = "reanalysis-era5-land",
  area = c(-90, -180, 90, 180),
  output_dir = "cds_data",
  user_id,
  user_key,
  max_retries = 3,
  retry_delay = 5,
  timeout = 7200
)
}
\arguments{
\item{start_year}{Integer. The starting year for data download.}

\item{end_year}{Integer. The ending year for data download.}

\item{start_month}{Integer. The starting month (default is 1).}

\item{end_month}{Integer. The ending month (default is 12).}

\item{variables}{Character vector. Variables to download.
Default includes common variables: \code{c("10m_u_component_of_wind", "10m_v_component_of_wind",
"2m_temperature", "total_precipitation")}.}

\item{dataset}{Character. Dataset short name (default is "reanalysis-era5-land").}

\item{area}{Numeric vector. Geographical area specified as \code{c(North, West, South, East)}.}

\item{output_dir}{Character. Directory to save the downloaded data (default is "cds_data").}

\item{user_id}{Character. Your ECMWF user ID.}

\item{user_key}{Character. Your ECMWF API key.}

\item{max_retries}{Integer. Maximum number of retry attempts in case of download failure (default is 3).}

\item{retry_delay}{Numeric. Delay between retry attempts in seconds (default is 5).}

\item{timeout}{Numeric. Timeout duration for each request in seconds (default is 7200, i.e., 2 hours).}
}
\value{
None. Data is downloaded to the specified output directory.
}
\description{
Downloads ERA5-Land data from the ECMWF Climate Data Store for the specified time range and variables.
Implements a retry mechanism to handle transient errors during data download.
}
\examples{
\dontrun{
# Set your ECMWF user ID and key
user_id <- "your_user_id"
user_key <- "your_api_key"

# Define the geographical area (North, West, South, East)
area <- c(90, -180, -90, 180) # Global

# Download data for 2020
download_data(
  start_year = 2020,
  end_year = 2020,
  variables = c("2m_temperature", "total_precipitation"),
  area = area,
  user_id = user_id,
  user_key = user_key
)
}
}
