% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{reverse_if_direct_mode}
\alias{reverse_if_direct_mode}
\title{Reverse Origins and Destinations for Direct Modes}
\usage{
reverse_if_direct_mode(origins, destinations, mode_list, data_path)
}
\arguments{
\item{origins}{A data frame representing origin locations.}

\item{destinations}{A data frame representing destination locations.}

\item{mode_list}{A named list containing the routing modes:}
}
\value{
List origins and destinations unchanges or in swapper order
}
\description{
Swaps the \code{origins} and \code{destinations} data frames if certain conditions are
met, specifically to optimize routing performance with R5's one-to-many
algorithm. The function reverses the direction of analysis when the transit
mode is empty and the direct modes are WALK or BICYCLE and when the number of
origin points is greater than the number of destination points.
}
\seealso{
Other setting functions: 
\code{\link{set_breakdown}()},
\code{\link{set_cutoffs}()},
\code{\link{set_elevation}()},
\code{\link{set_expanded_travel_times}()},
\code{\link{set_fare_cutoffs}()},
\code{\link{set_fare_structure}()},
\code{\link{set_max_fare}()},
\code{\link{set_max_lts}()},
\code{\link{set_max_rides}()},
\code{\link{set_monte_carlo_draws}()},
\code{\link{set_n_threads}()},
\code{\link{set_new_congestion}()},
\code{\link{set_new_lts}()},
\code{\link{set_output_dir}()},
\code{\link{set_percentiles}()},
\code{\link{set_progress}()},
\code{\link{set_speed}()},
\code{\link{set_suboptimal_minutes}()},
\code{\link{set_time_window}()},
\code{\link{set_verbose}()}
}
\concept{setting functions}
\keyword{internal}
