% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fare_structure.R
\name{read_fare_structure}
\alias{read_fare_structure}
\title{Read a fare structure object from a file}
\usage{
read_fare_structure(file_path, encoding = "UTF-8")
}
\arguments{
\item{file_path}{A path pointing to a fare structure with a \code{.zip}
extension.}

\item{encoding}{A string. Passed to \code{\link[data.table:fread]{data.table::fread()}}, defaults to
\code{"UTF-8"}. Other possible options are \code{"unknown"} and \code{"Latin-1"}. Please
note that this is not used to re-encode the input, but to enable handling
encoded strings in their native encoding.}
}
\value{
A fare structure object.
}
\description{
Read a fare structure object from a file
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
path <- system.file("extdata/poa/fares/fares_poa.zip", package = "r5r")
fare_structure <- read_fare_structure(path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other fare structure: 
\code{\link{setup_fare_structure}()},
\code{\link{write_fare_structure}()}
}
\concept{fare structure}
