% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{nrow_ml}
\alias{nrow_ml}
\title{Multilevel Number of Rows}
\usage{
nrow_ml(data, grp.nm)
}
\arguments{
\item{data}{data.frame of data.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
grouping variables.}
}
\value{
list with two elements providing the sample sizes (ignoring missing
  data). The first element is named "within" and contains the number of rows
  in the data. The second element is named "between" and contains the number
  of groups in the data.
}
\description{
\code{nrow_ml} computes the number rows in the data as well as the number of
groups in the data. This corresponds to the within-group sample size and
between-group sample size (ignoring any missing data). This is simply a
combination of \code{nrow} + \code{ngrp}.
}
\examples{

# one grouping variable
nrow_ml(data = as.data.frame(ChickWeight), grp.nm = "Chick")

# multiple grouping variables
nrow_ml(data = mtcars, grp.nm = c("vs","am"))

}
\seealso{
\code{\link{ncases_ml}}
   \code{\link{nrow_by}}
   \code{\link{ncases_by}}
   \code{\link{ngrp}}
}
