% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{ncases_desc}
\alias{ncases_desc}
\title{Describe Number of Cases in Data by Group}
\usage{
ncases_desc(
  data,
  vrb.nm = str2str::pick(names(data), val = grp.nm, not = TRUE),
  grp.nm,
  ov.min = 1,
  prop = TRUE,
  inclusive = TRUE,
  interp = FALSE,
  skew = TRUE,
  ranges = TRUE,
  trim = 0.1,
  type = 3,
  quant = c(0.25, 0.75),
  IQR = FALSE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
set of variables to base the ncases on.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
grouping variables.}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{length(vrb.nm)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the case
should be included if the frequency of observed values in a row is exactly
equal to \code{ov.min}.}

\item{interp}{logical vector of length 1 specifying whether the median should
be standard (FALSE) or interpolated (TRUE).}

\item{skew}{logical vector of length 1 specifying whether skewness and
kurtosis should be calculated (TRUE) or not (FALSE).}

\item{ranges}{logical vector of length 1 specifying whether the minimum,
maximum, and range (i.e., maximum - minimum) should be calculated (TRUE) or
not (FALSE). Note, if \code{ranges} = FALSE, the trimmed mean and median
absolute deviation is also not computed as per the \code{psych::describe}
function behavior.}

\item{trim}{numeric vector of length 1 specifying the top and bottom
quantiles of data that are to be excluded when calculating the trimmed
mean. For example, the default value of 0.1 means that only data within the
10th - 90th quantiles are used for calculating the trimmed mean.}

\item{type}{numeric vector of length 1 specifying the type of skewness and
kurtosis coefficients to compute. See the details of
\code{psych::describe}. The options are 1, 2, or 3.}

\item{quant}{numeric vector specifying the quantiles to compute. Foe example,
the default value of c(0.25, 0.75) computes the 25th and 75th quantiles of
the group number of cases. If \code{quant} = NULL, then no quantiles are
returned.}

\item{IQR}{logical vector of length 1 specifying whether to compute the
Interquartile Range (TRUE) or not (FALSE), which is simply the 75th quantil
- 25th quantile.}
}
\value{
numeric vector containing descriptive statistics about number of cases by group.
Note, which elements are returned depends on the arguments. See each argument's description.

\describe{
   \item{n}{number of groups}
   \item{mean}{mean}
   \item{sd}{standard deviation}
   \item{median}{median (standard if \code{interp} = FALSE, interpolated if \code{interp} = TRUE)}
   \item{trimmed}{trimmed mean based on \code{trim}}
   \item{mad}{median absolute difference}
   \item{min}{minimum}
   \item{max}{maximum}
   \item{range}{maximum - minumum}
   \item{skew}{skewness}
   \item{kurtosis}{kurtosis}
   \item{se}{standard error of the mean}
   \item{IQR}{75th quantile - 25th quantile}
   \item{QX.XX}{quantiles, which are named by \code{quant} (e.g., 0.25 = "Q0.25")}
}
}
\description{
\code{ncases_desc} computes descriptive statistics about the number of cases
by group in a data.frame. This is often done in diary studies to obtain
information about compliance for the sample. Through the use of the
\code{ov.min}, \code{prop}, and \code{inclusive} arguments, the user can
specify how many missing values are allowed in a row for it to be counted.
\code{ncases_desc} is simply \code{ncases_by} + \code{psych::describe}.
}
\examples{
tmp_nm <- c("outcome","case","session","trt_time")
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp_nm]
stats_by <- psych::statsBy(dat, group = "case") # doesn't include everything you want
ncases_desc(data = dat, grp.nm = "case")
dat2 <- as.data.frame(ChickWeight)
ncases_desc(data = dat2, grp.nm = "Chick")
ncases_desc(data = dat2, grp.nm = "Chick", trim = .05)
ncases_desc(data = dat2, grp.nm = "Chick", ranges = FALSE)
ncases_desc(data = dat2, grp.nm = "Chick", quant = NULL)
ncases_desc(data = dat2, grp.nm = "Chick", IQR = TRUE)
}
\seealso{
\code{\link{ncases_by}}
   \code{\link[psych]{describe}}
}
