% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia_functions.R
\name{amd_uni}
\alias{amd_uni}
\title{Amount of Missing Data - Univariate}
\usage{
amd_uni(data, vrb.nm, prop = TRUE, ov = FALSE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of the colnames from \code{data} specifying
the variables.}

\item{prop}{logical vector of length 1 specifying whether the frequency of
missing values should be returned as a proportion (TRUE) or a count
(FALSE).}

\item{ov}{logical vector of length 1 specifying whether the frequency of
observed values (TRUE) should be returned rather than the frequency of
missing values (FALSE).}
}
\value{
numeric vector of length = \code{length(vrb.nm)} and names =
  \code{vrb.nm} providing the frequency of missing (or observed if \code{ov}
  = TRUE) values per variable. If \code{prop} = TRUE, the values will range
  from 0 to 1. If \code{prop} = FALSE, the values will range from 0 to
  \code{nrow(data)}.
}
\description{
\code{amd_uni} by default computes the proportion of missing data for
variables in a data.frame, with arguments to allow for counts instead of
proportions (i.e., \code{prop}) or observed data rather than missing data
(i.e., \code{ov}). It is univariate in that each variable is treated in
isolation. \code{amd_uni} is a simple wrapper for \code{\link{colNA}}.
}
\examples{

amd_uni(data = airquality, vrb.nm = names(airquality)) # proportion of missing data
amd_uni(data = airquality, vrb.nm = names(airquality),
   ov = TRUE) # proportion of observed data
amd_uni(data = airquality, vrb.nm = names(airquality),
   prop = FALSE) # count of missing data
amd_uni(data = airquality, vrb.nm = names(airquality),
   prop = FALSE, ov = TRUE) # count of observed data

}
\seealso{
\code{\link{amd_bi}}
   \code{\link{amd_multi}}
}
