% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygon_to_raster.R
\name{polygon_to_raster}
\alias{polygon_to_raster}
\title{Create and save raster images for different dates and times}
\usage{
polygon_to_raster(
  data,
  nx,
  ny,
  template,
  var = "percent_change",
  filename,
  path
)
}
\arguments{
\item{data}{A \code{sf} POLYGON data.frame with the variable we want to represent
in the raster.}

\item{nx}{Integer; number of cells in x direction.}

\item{ny}{Integer; number of cells in y direction.}

\item{template}{A \code{sf} POLYGON data.frame}

\item{var}{The column name of the variable to plot.}

\item{filename}{Select a name for the file. The date and time will
be included automatically in the name.}

\item{path}{Path where the files should be stored.}
}
\value{
as many .tif files as dates and times in the dataset
}
\description{
Creates one raster by each date and time reported and
saves it as a \code{.tif}.
}
\examples{
\donttest{
files <- read_fb_mobility_files(
  path_to_csvs = paste0(system.file("extdata",
    package = "quadkeyr"
  ), "/"),
  colnames = c(
    "lat", "lon",
    "quadkey", "date_time",
    "n_crisis", "percent_change"
  ),
  coltypes = list(
    lat = "d",
    lon = "d",
    quadkey = "c",
    date_time = "T",
    n_crisis = "c",
    percent_change = "c"
  )
)

# Get a regular grid and create the polygons
regular_grid <- get_regular_polygon_grid(data = files)

# Keep only the QuadKeys reported
files_polygons <- files |>
  dplyr::inner_join(regular_grid$data,
    by = c("quadkey")
  )

# Generate the raster files
polygon_to_raster(
  data = files_polygons,
  nx = regular_grid$num_cols,
  ny = regular_grid$num_rows,
  template = files_polygons,
  var = "percent_change",
  filename = "cityA",
  path = paste0(
    system.file("extdata",
      package = "quadkeyr"
    ),
    "/"
  )
)
}
}
\seealso{
\code{\link[stars]{st_as_stars}}, \code{\link[stars]{st_rasterize}}

\code{\link{missing_combinations}}
}
