% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iron.R
\docType{data}
\name{iron}
\alias{iron}
\title{Iron levels intercross data}
\format{
An object of class \code{cross}.  See \code{\link[qtl:read.cross]{qtl::read.cross()}}
for details.
}
\source{
Andrew G. Smith, MRC Toxicology Unit, \email{ags5@le.ac.uk}
}
\usage{
iron
}
\description{
Data from a mouse intercross experiment (using the C57BL/6J/Ola and SWR/Ola
strains) on basal iron levels in the liver and spleen.
}
\details{
An intercross with 284 individuals (including both sexes and both cross
directions), each with measures of iron (in \eqn{\mu g/g}{ug/g}) in the
liver and spleen.
}
\examples{
data(iron)
library(qtl)
plot(iron)

}
\references{
Grant, G. G., Robinson, S. W., Edwards, R. E., Clothier, B.,
Davies, R., Judah, D. J., Broman, K. W. and Smith, A. G. (2006) Multiple
polymorphic loci determine basal hepatic and splenic iron status in mice.
\emph{Hepatology} \strong{44}, 174--185.
}
\seealso{
\code{link{gutlength}}, \code{link{myocard}}, \code{link{nf1}},
\code{link{ovar}}, \code{link{trout}}
}
\keyword{datasets}
