% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_normalized_entropy.R
\name{calc_normalized_entropy}
\alias{calc_normalized_entropy}
\title{Calculate Normalized Entropy for Categorical Variables}
\usage{
calc_normalized_entropy(x)
}
\arguments{
\item{x}{A character vector or factor containing categorical data.}
}
\value{
A numeric value between 0 and 1 representing the normalized entropy:
\itemize{
\item Values closer to 0 indicate less diversity/uncertainty
\item Values closer to 1 indicate more diversity/uncertainty
}
}
\description{
Computes the normalized entropy (uncertainty measure) for categorical variables,
providing a standardized measure of dispersion or randomness in the data.
}
\details{
The function:
\itemize{
\item Handles both character vectors and factors as input
\item Treats NA values as a separate category
\item Normalizes entropy to range (0,1) where:
\itemize{
\item 0 indicates complete certainty (one category dominates)
\item 1 indicates maximum uncertainty (equal distribution)
}
}

The calculation process:
\enumerate{
\item Computes category proportions
\item Calculates raw entropy using Shannon's formula
\item Normalizes by dividing by maximum possible entropy
}
}
\examples{
# Calculate entropy for a simple categorical vector
x <- c("A", "B", "B", "C", "C", "C", "D", "D", "D", "D")
calc_normalized_entropy(x)

# Handle missing values
y <- c("A", "B", NA, "C", "C", NA, "D", "D")
calc_normalized_entropy(y)

# Works with factors too
z <- factor(c("Low", "Med", "Med", "High", "High", "High"))
calc_normalized_entropy(z)

}
