% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varRatio.R
\name{varRatio}
\alias{varRatio}
\title{First order approximation to variance of y-ordinate to slope ratio}
\usage{
varRatio(phat = 0.99, b, vv, link = "cloglog")
}
\arguments{
\item{phat}{Mortality proportion}

\item{b}{Length 2 vector of intercept and slope}

\item{vv}{Variance-covariance matrix for intercept and slope}

\item{link}{Link function that transforms expected mortalities
to the scale of the linear predictor}
}
\value{
A vector, with elements
\item{xhat}{Estimate}
\item{var}{Variance, calculated using the Delta method,  See
the help page for \code{\link{fieller}} for further details
and references.}
}
\description{
In contexts where an LD99 estimate will be used as a data value
in a further analysis step, the inverse of the variance may be
used as a weight.  The y-ordinate is for the link function
transformed value of a specified mortality proportion, commonly
0.50, or 0.90, or 0.99
}
\details{
This function should only be used, in order to speed up
calculations that use the function \code{\link{fieller}}
(call \code{fieller} with (\code{type="Delta"})),
in a context where it is to be used many times,
and where a check has been made that its use leads to
confidence intervals that are a close approximation to those
given with the default argument (\code{type="Fieller"}).
}
\examples{
redDel <- subset(qra::codling1988, Cultivar=="Red Delicious")
redDel.glm <- glm(cbind(dead,total-dead)~ct, data=redDel,
                  family=quasibinomial(link='cloglog'))
vv <- summary(redDel.glm)$cov.scaled
qra::varRatio(0.99, b=coef(redDel.glm), vv=vv, link="cloglog")
}
