% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldp.R
\name{foldp}
\alias{foldp}
\title{Title Function to calculate ratio of \code{p+eps} to \code{1-p+eps}.}
\usage{
foldp(p, eps)
}
\arguments{
\item{p}{Proportion}

\item{eps}{Offset. The choice \code{eps}=0.01 has the
same effect as replacing \eqn{\frac{r}{n-r}} by
\eqn{\frac{r+0.5}{n-r+0.5}} when \eqn{n=50}, or by
\eqn{\frac{r+1}{n-r+1}} when \eqn{n=100}}
}
\value{
\code{(p+eps)/(1-p+eps)}
}
\description{
This is a convenience function that returns
\eqn{\frac{p+\epsilon}{1-p+\epsilon}}.  It calculates
the argument that is supplied to the \code{log}
function in Tukey's \sQuote{flog}.
}
\examples{
foldp(c(0.2,0.75), 0)
}
