% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiGroupTestBMDD.R
\name{Multi.group.test.bMDD}
\alias{Multi.group.test.bMDD}
\title{Multi-group test bMDD}
\usage{
Multi.group.test.bMDD(
  groups,
  counts,
  control.name = NULL,
  alpha = 0.05,
  shift.step = -0.25,
  bootstrap.runs = 200,
  power = 0.8,
  max.iterations = 1000,
  use.fixed.random.seed = NULL,
  CPCAT.bootstrap.runs = 200,
  Dunnett.GLM.zero.treatment.action = "log(x+1)",
  show.progress = TRUE,
  show.results = TRUE,
  get.effect.and.power = FALSE,
  use.CMP.distribution = FALSE,
  CMP.dispersion.factor = 1,
  test = "CPCAT"
)
}
\arguments{
\item{groups}{Group vector}

\item{counts}{Vector with count data}

\item{control.name}{Character string with control group name (optional)}

\item{alpha}{Significance level}

\item{shift.step}{Step of shift (negative as a reduction is assumed)}

\item{bootstrap.runs}{Number of bootstrap runs}

\item{power}{Proportion of bootstrap.runs that return significant differences}

\item{max.iterations}{Max. number of iterations to not get stuck in the while loop}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{CPCAT.bootstrap.runs}{Bootstrap runs within CPCAT method}

\item{Dunnett.GLM.zero.treatment.action}{Dunnett.GLM method to be used for treatments only containing zeros}

\item{show.progress}{Show progress for each shift of lambda}

\item{show.results}{Show results}

\item{get.effect.and.power}{Return effect size (percent of control) and power for each step (only for last treatment)}

\item{use.CMP.distribution}{Use Conway-Maxwell-Poisson distribution for sampling}

\item{CMP.dispersion.factor}{Dispersion parameter phi has to be sqrt(factor) to scale the variance by this factor}

\item{test}{Either "CPCAT" or "GLM.Dunnett"}
}
\value{
Data frame with results from bMDD analysis
}
\description{
Idea: shift lambda of Poisson distribution until there is a certain proportion of significant results
}
