% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPCAT.R
\name{CPCAT}
\alias{CPCAT}
\title{CPCAT}
\usage{
CPCAT(
  groups,
  counts,
  control.name = NULL,
  bootstrap.runs = 10000,
  hampel.threshold = 5,
  use.fixed.random.seed = NULL,
  get.contrasts.and.p.values = FALSE,
  show.output = TRUE
)
}
\arguments{
\item{groups}{Group vector}

\item{counts}{Vector with count data}

\item{control.name}{Character string with control group name (optional)}

\item{bootstrap.runs}{Number of bootstrap runs}

\item{hampel.threshold}{Threshold for Hampel identifier (measure for over-/underdispersion)}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{get.contrasts.and.p.values}{Get each row of the contrast matrices evaluated}

\item{show.output}{Show/hide output}
}
\value{
R object with results and information from CPCAT calculations
}
\description{
When conducting statistical tests with multiple treatments, such as a control group and
increasing concentrations of a test substance, ANOVA and parametric post-hoc tests (e.g. Dunnett's test)
are commonly used. However, these tests require the assumptions of homogeneous variances and normally
distributed data. For count data (e.g. counts of animals), these assumptions are typically violated,
as the data are usually Poisson-distributed. Additionally, multiple testing using post-hoc tests can
lead to alpha-inflation. To address these issues, CPCAT was proposed by Lehmann et al. (2016). CPCAT has
two components. The first is the Closure Principle (CP) developed by Bretz et al. (2010), which aims
to eliminate alpha-inflation. CP applies a stepwise approach to identify at which concentration effects
begin to occur. The second part of CPCAT is the actual significance test, CAT (Computational Approach
Test; introduced by Chang et al., 2010), which uses a test based on the Poisson distribution rather
than a parametric test based on normal distribution assumptions. For details on the structure of the
input data, please refer to the dataset 'Daphnia.counts' provided alongside this package.
}
\examples{
Daphnia.counts	# example data provided alongside the package

# Test CPCAT
CPCAT(groups = Daphnia.counts$Concentration,
	 counts = Daphnia.counts$Number_Young,
	 control.name = NULL,
	 bootstrap.runs = 10000,
	 use.fixed.random.seed = 123,  #fixed seed for reproducible results
	 get.contrasts.and.p.values = FALSE,
	 show.output = TRUE)
}
\references{
Bretz, F.; Hothorn, T.; Westfall, P. (2010): Multiple comparisons using R. 1st Edition, Chapman and Hall/CRC, New York

Chang, C.-H.; Pal, N.; Lin, J.-J. (2010): A Note on Comparing Several Poisson Means. In: Commun. Stat. Simul. Comput., 2010, 39(8), p. 1605-1627, https://doi.org/10.1080/03610918.2010.508860

Lehmann, R.; Bachmann, J.; Maletzki, D.; Polleichtner, C.; Ratte, H.; Ratte, M. (2016): A new approach to overcome shortcomings with multiple testing of reproduction data in ecotoxicology. In: Stochastic Environmental Research and Risk Assessment, 2016, 30(3), p. 871-882, https://doi.org/10.1007/s00477-015-1079-4
}
