% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbin_heatmap.R
\name{qbin_heatmap}
\alias{qbin_heatmap}
\title{Quantile binned heatmap}
\usage{
qbin_heatmap(
  data,
  x = NULL,
  n = 25,
  min_bin_size = NULL,
  overlap = NULL,
  bins = c(n),
  type = c("gradient", "size"),
  ncols = NULL,
  auto_fill = FALSE,
  fill = "#2f4f4f",
  low = "#eeeeee",
  high = "#2f4f4f",
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} to be binned}

\item{x}{\code{character} variable name used for the quantile binning}

\item{n}{\code{integer} number of quantile bins.}

\item{min_bin_size}{\code{integer} minimum number of rows/data points that should be
in a quantile bin. If NULL it is initially \code{sqrt(nrow(data))}}

\item{overlap}{\code{logical} if \code{TRUE} the quantile bins will overlap. Default value will be
\code{FALSE}.}

\item{bins}{\code{integer} vector with the number of bins to use for the x and y axis.}

\item{type}{The type of heatmap to use. Either "gradient" or "size".}

\item{ncols}{The number of column to be used in the layout.}

\item{auto_fill}{If \code{TRUE}, use a different color for each category.}

\item{fill}{The color used for categorical variables.}

\item{low}{The color used for low values in the heatmap.}

\item{high}{The color used for high values in the heatmap.}

\item{...}{Additional arguments to pass to the plot functions}
}
\value{
A \code{list} of ggplot objects.
}
\description{
\code{qbin_heatmap} shows the distribution of the \code{y}
of variables for each quantile bin of \code{x}. It is an alternative to
\code{\link[=qbin_boxplot]{qbin_boxplot()}}, fine graining the distribution per \code{\link[=qbin]{qbin()}}.
\code{\link[=qbin_barplot]{qbin_barplot()}} highlights the median/mean of the quantile bins, while
}
\examples{
\donttest{
  qbin_heatmap(
    iris,
    "Sepal.Length",
    auto_fill = TRUE
  )

  qbin_heatmap(
    iris,
    "Sepal.Length",
    auto_fill = TRUE,
    type = "size"
  )

  qbin_heatmap(
    iris,
    "Sepal.Length",
    overlap = TRUE,
    auto_fill = TRUE
  )

  data("diamonds", package="ggplot2")

  qbin_heatmap(
    diamonds[c(1,7:9)],
    x = "price",
    n = 150
  )



}
}
\seealso{
Other qbin plotting functions: 
\code{\link{qbin_barplot}()},
\code{\link{qbin_boxplot}()},
\code{\link{qbin_lineplot}()}
}
\concept{qbin plotting functions}
