% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_2d_animated}
\alias{plot_2d_animated}
\title{Plot a 2D Animated Heatmap for Concentration Over Time}
\usage{
plot_2d_animated(
  data,
  grid_coords,
  start,
  end,
  output_dt,
  frames = 100,
  transition = 99,
  save = FALSE,
  interpolate_grid = FALSE,
  granularity = 100
)
}
\arguments{
\item{data}{A matrix or array of grid concentration results from `simulate_grid_mode()`.}

\item{grid_coords}{A list containing the same grid coordinates passed to `simulate_grid_mode()`.}

\item{start}{A character string specifying the start time of the simulation (e.g., "YYYY-MM-DD HH:MM:SS").}

\item{end}{A character string specifying the end time of the simulation (e.g., "YYYY-MM-DD HH:MM:SS").}

\item{output_dt}{A character string or numeric value specifying the time interval between outputs.}

\item{frames}{Numeric. Duration between frames in the animation (milliseconds). Default is 100.}

\item{transition}{Numeric. Duration for transitioning between frames (milliseconds). Default is 99.}

\item{save}{Logical. If `TRUE`, saves the plot as an HTML file named `2D_heatmap.html` and specifies saved location. Default set to `FALSE`.}

\item{interpolate_grid}{Logical. If `TRUE`, applies interpolation to refine grid resolution and make the heatmap smoother. Default `FALSE`.}

\item{granularity}{Numeric. Sets the number of points in the finer grid resolution when `interpolate_grid = TRUE`. Default `100`.}
}
\value{
A `plotly` object representing the animated heatmap.
}
\description{
This function generates a 2D animated heatmap using `plotly` to visualize the
movement of a plume over time. The animation is based on grid concentration data
from `simulate_grid_mode()` output.
}
\examples{
\donttest{
set.seed(123)

sim_dt <- 10
puff_dt <- 10
output_dt <- 60
start_time <- "2024-01-01 12:00:00"
end_time <- "2024-01-01 13:00:00"
source_coords <- c(0, 0, 2.5)
emission_rate <- 3.5
wind_data <- data.frame(
  wind_u = runif(3601, min = -3, max = 0.7),
  wind_v = runif(3601, min = -3, max = 1.5)
)

grid_coords <- list(
  x = seq(-2, 2, by = 1),
  y = seq(-2, 2, by = 1),
  z = seq(0, 5, by = 1)
)

out <- simulate_grid_mode(
  start_time = start_time,
  end_time = end_time,
  source_coords = source_coords,
  emission_rate = emission_rate,
  wind_data = wind_data,
  grid_coords = grid_coords,
  sim_dt = sim_dt,
  puff_dt = puff_dt,
  output_dt = output_dt,
  puff_duration = 1200
)

plot_2d_animated(data = out,
  grid_coords = grid_coords,
  start = start_time,
  end = end_time,
  output_dt = output_dt)
}
}
