% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte.R
\name{pte_default}
\alias{pte_default}
\title{Default, General Function for Computing Treatment Effects with Panel Data}
\usage{
pte_default(
  yname,
  gname,
  tname,
  idname,
  data,
  xformula = ~1,
  d_outcome = FALSE,
  d_covs_formula = ~-1,
  lagged_outcome_cov = FALSE,
  est_method = "dr",
  anticipation = 0,
  base_period = "varying",
  control_group = "notyettreated",
  weightsname = NULL,
  cband = TRUE,
  alp = 0.05,
  boot_type = "multiplier",
  biters = 100,
  cl = 1
)
}
\arguments{
\item{yname}{Name of outcome in \code{data}}

\item{gname}{Name of group in \code{data}}

\item{tname}{Name of time period in \code{data}}

\item{idname}{Name of id in \code{data}}

\item{data}{balanced panel data}

\item{xformula}{one-sided formula for covariates used in the propensity score
and outcome regression models}

\item{d_outcome}{Whether or not to take the first difference of the outcome.
The default is FALSE.  To use difference-in-differences, set this to be TRUE.}

\item{d_covs_formula}{A formula for time varying covariates to enter the
first estimation step models.  The default is not to include any, and, hence,
to only include pre-treatment covariates.}

\item{lagged_outcome_cov}{Whether to include the lagged outcome as a covariate.
Default is FALSE.}

\item{est_method}{Which type of estimation method to use. Default is "dr" for
doubly robust.  The other option is "reg" for regression adjustment.}

\item{anticipation}{how many periods before the treatment actually takes
place that it can have an effect on outcomes}

\item{base_period}{The type of base period to use.  This only affects
the numeric value of results in pre-treatment periods.  Results in
post-treatment periods are not affected by this choice.  The default
is "varying", where the base period will "back up" to the immediately
preceding period in pre-treatment periods.  The other option is "universal"
where the base period is fixed in pre-treatment periods to be the period
right before the treatment starts.  "Universal" is commonly used in
difference-in-differences applications, but can be unnatural for other
identification strategies.}

\item{control_group}{Which group is used as the comparison group.
The default choice is "notyettreated", but
different estimation strategies can implement their own choices
for the control group}

\item{weightsname}{The name of the column that contains sampling weights.
The default is NULL, in which case no sampling weights are used.}

\item{cband}{whether or not to report a uniform (instead of pointwise)
confidence band (default is TRUE)}

\item{alp}{significance level; default is 0.05}

\item{boot_type}{should be one of "multiplier" (the default) or "empirical".
The multiplier bootstrap is generally much faster, but \code{attgt_fun} needs
to provide an expression for the influence function (which could be challenging
to figure out).  If no influence function is provided, then the \code{pte}
package will use the empirical bootstrap no matter what the value of this
parameter.}

\item{biters}{number of bootstrap iterations; default is 100}

\item{cl}{number of clusters to be used when bootstrapping; default is 1}
}
\value{
\code{pte_results} object
}
\description{
This is a generic/example wrapper for a call to the \code{pte} function.

This function provides access to difference-in-differences and unconfoundedness
based identification/estimation strategies given (i) panel data and (ii)
staggered treatment adoption
}
\examples{
# example using minimum wage data
# and a lagged outcome unconfoundedness strategy
library(did)
data(mpdta)
lou_res <- pte_default(
  yname = "lemp",
  gname = "first.treat",
  tname = "year",
  idname = "countyreal",
  data = mpdta,
  xformula = ~lpop,
  d_outcome = FALSE,
  d_covs_formula = ~lpop,
  lagged_outcome_cov = TRUE
)

summary(lou_res)
ggpte(lou_res)

}
