% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonise.R
\name{harmonise_four_labels}
\alias{harmonise_four_labels}
\title{Harmonise Four Labels}
\usage{
harmonise_four_labels(
  arg,
  label_one,
  label_two,
  label_three,
  label_four,
  label_unknown,
  harmonise_label_one = "group_1",
  harmonise_label_two = "group_2",
  harmonise_label_three = "group_3",
  harmonise_label_four = "group_4",
  harmonise_label_unknown = NA,
  error_call = rlang::caller_env()
)
}
\arguments{
\item{arg}{Input argument, in characters to be harmonised}

\item{label_one}{Input character vector representing the ways to identify \code{harmonise_label_one}}

\item{label_two}{Input character vector representing the ways to identify \code{harmonise_label_two}}

\item{label_three}{Input character vector representing the ways to identify \code{harmonise_label_three}}

\item{label_four}{Input character vector representing the ways to identify \code{harmonise_label_four}}

\item{label_unknown}{Input character vector representing the ways to identify \code{harmonise_label_unknown}}

\item{harmonise_label_one}{Input character representing the harmonised label for \code{label_one}
Default: 'group_1'}

\item{harmonise_label_two}{Input character representing the harmonised label for \code{label_two}
Default: 'group_2'}

\item{harmonise_label_three}{Input character representing the harmonised label for \code{label_three}
Default: 'group_3'}

\item{harmonise_label_four}{Input character representing the harmonised label for \code{label_four}
Default: 'group_4'}

\item{harmonise_label_unknown}{Input character representing the harmonised label for \code{label_unknown}
Default: NA}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
Character representing one of the four standardise labels.
}
\description{
Function to map an input from
four different list into one of the four standardise labels
}
\examples{
label_cpt_no_chest_pain <- c("no chest pain", "normal")
label_cpt_nonanginal <- c("nonanginal", "unspecified")
label_cpt_atypical <- c("atypical", "Atypical")
label_cpt_typical <- c("typical", "angina")
label_cpt_unknown <- c(NA, NaN)

# Gives harmonise_label_one if there is valid input of chest_pain_type
chest_pain_type <- "normal"

harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
)

# Gives harmonise_label_two if there is valid input of chest_pain_type
chest_pain_type <- "unspecified"

harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
)

# Gives harmonise_label_three if there is valid input of chest_pain_type
chest_pain_type <- "Atypical"

harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
)

# Gives harmonise_label_four if there is valid input of chest_pain_type
chest_pain_type <- "angina"

harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
)

# Gives harmonise_label_unknown if there is valid missing input of chest_pain_type
chest_pain_type <- NaN

harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
)

# Gives harmonise_label_unknown if there is valid missing input of chest_pain_type
chest_pain_type <- "NIL"
label_cpt_unknown <- c("NIL")

harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
)

# Gives error of invalid typical chest pain input with partial match
chest_pain_type <- "Typical"
label_cpt_unknown <- c(NA, NaN)

try(harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
))

# Gives error of invalid typical chest pain input without partial match
chest_pain_type <- "Something"
label_cpt_unknown <- c(NA, NaN)

try(harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
))

# Gives error of invalid missing input of chest_pain_type
chest_pain_type <- NA
label_cpt_unknown <- c("NIL")

try(harmonise_four_labels(
   arg = chest_pain_type,
   label_one = label_cpt_no_chest_pain,
   label_two = label_cpt_nonanginal,
   label_three = label_cpt_atypical,
   label_four = label_cpt_typical,
   label_unknown = label_cpt_unknown,
   harmonise_label_one = "no chest pain",
   harmonise_label_two = "nonanginal",
   harmonise_label_three = "atypical",
   harmonise_label_four = "typical",
   harmonise_label_unknown = NA
))


}
