% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logis_re.R
\name{logis_re}
\alias{logis_re}
\title{Main Function for fitting the random effect logistic model}
\usage{
logis_re(
  formula = NULL,
  data = NULL,
  Y = NULL,
  Z = NULL,
  ProvID = NULL,
  Y.char = NULL,
  Z.char = NULL,
  ProvID.char = NULL,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula object describing the model to be fitted,
with the response variable on the left of a ~ operator and covariates on the right,
separated by + operators. The random effect of the provider identifier is specified using \code{(1 | )}.}

\item{data}{a data frame containing the variables named in the \code{formula},
or the columns specified by \code{Y.char}, \code{Z.char}, and \code{ProvID.char}.}

\item{Y}{a numeric vector representing the response variable.}

\item{Z}{a matrix or data frame representing the covariates, which can include both numeric and categorical variables.}

\item{ProvID}{a numeric vector representing the provider identifier.}

\item{Y.char}{a character string specifying the column name of the response variable in the \code{data}.}

\item{Z.char}{a character vector specifying the column names of the covariates in the \code{data}.}

\item{ProvID.char}{a character string specifying the column name of the provider identifier in the \code{data}.}

\item{\dots}{additional arguments passed to \code{\link[lme4]{glmer}} for further customization.}
}
\value{
A list of objects with S3 class \code{"logis_re"}:
\item{coefficient}{a list containing the estimated coefficients:
\code{FE}, the fixed effects for each predictor and the intercept, and \code{RE}, the random effects for each provider.}
\item{variance}{a list containing the variance estimates:
\code{FE}, the variance-covariance matrix of the fixed effect coefficients, and \code{RE}, the variance of the random effects.}
\item{fitted}{the predicted probability of each observation having a response of 1.}
\item{observation}{the original response of each individual.}
\item{linear_pred}{the linear predictor of each individual.}
\item{data_include}{the data used to fit the model, sorted by the provider identifier.
For categorical covariates, this includes the dummy variables created for
all categories except the reference level.}
\item{char_list}{a list of the character vectors representing the column names for
the response variable, covariates, and provider identifier.
For categorical variables, the names reflect the dummy variables created for each category.}
\item{Loglkd}{the log-likelihood.}
\item{AIC}{Akaike information criterion.}
\item{BIC}{Bayesian information criterion.}
}
\description{
Fit a random effect logistic model via \code{\link[lme4]{glmer}} from the \code{lme4} package.
}
\details{
This function is used to fit a random effect logistic model of the form:
\deqn{\text{logit}(P(Y_{ij} = 1 \mid \alpha_i, \mathbf{Z}_{ij})) = \mu + \alpha_i + \mathbf{Z}_{ij}^\top \boldsymbol{\beta},}
where \eqn{Y_{ij}} is the binary outcome for individual \eqn{j} in provider \eqn{i},
\eqn{\mu} is the overall intercept, \eqn{\alpha_i} is the random effect for provider \eqn{i},
\eqn{\mathbf{Z}_{ij}} are the covariates, and \eqn{\boldsymbol\beta} is the vector of coefficients for the covariates.

The model is fitted by overloading the \code{\link[lme4]{glmer}} function from the \code{lme4} package.
Three different input formats are accepted:
a formula and dataset, where the formula is of the form \code{response ~ covariates + (1 | provider)}, with \code{provider} representing the provider identifier;
a dataset along with the column names of the response, covariates, and provider identifier;
or the outcome vector \eqn{\boldsymbol{Y}}, the covariate matrix or data frame \eqn{\mathbf{Z}}, and the provider identifier vector.

In addition to these input formats, all arguments from the \code{\link[lme4]{glmer}} function can be modified via \code{\dots},
allowing for customization of model fitting options.

If issues arise during model fitting, consider using the \code{data_check} function to perform a data quality check,
which can help identify missing values, low variation in covariates, high-pairwise correlation, and multicollinearity.
For datasets with missing values, this function automatically removes observations (rows) with any missing values before fitting the model.
}
\examples{
data(ExampleDataBinary)
outcome <- ExampleDataBinary$Y
covar <- ExampleDataBinary$Z
ProvID <- ExampleDataBinary$ProvID
data <- data.frame(outcome, ProvID, covar)
covar.char <- colnames(covar)
outcome.char <- colnames(data)[1]
ProvID.char <- colnames(data)[2]
formula <- as.formula(paste("outcome ~", paste(covar.char, collapse = " + "), "+ (1|ProvID)"))

# Fit logistic linear effect model using three input formats
fit_re1 <- logis_re(Y = outcome, Z = covar, ProvID = ProvID)
\donttest{
fit_re2 <- logis_re(data = data, Y.char = outcome.char,
Z.char = covar.char, ProvID.char = ProvID.char)
fit_re3 <- logis_re(formula, data)
}

}
\references{
Bates D, Maechler M, Bolker B, Walker S (2015). \emph{Fitting Linear Mixed-Effects Models Using lme4}.
Journal of Statistical Software, 67(1), 1-48.
\cr
}
\seealso{
\code{\link{data_check}}
}
