% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{write.mct}
\alias{write.mct}
\title{Write MapChart file}
\usage{
write.mct(
  maplist,
  mapdir = "mapping_files_MDSMap",
  file_info = paste("; MapChart file created on", Sys.Date()),
  filename = "MapFile",
  precision = 2,
  showMarkerNames = FALSE
)
}
\arguments{
\item{maplist}{A list of maps. In the first column marker names and in the second their position. All map data are
compiled into a single MapChart file.}

\item{mapdir}{Directory to which .mct files are written, by default the same directory
as for \code{\link{MDSMap_from_list}}}

\item{file_info}{A character string added to the first lines of the .mct file, by default a datestamp is recorded.}

\item{filename}{Character string of filename to write the .mct file to, by default "MapFile"}

\item{precision}{To how many decimal places should marker positions be specified (default = 2)?}

\item{showMarkerNames}{Logical, by default \code{FALSE}, if \code{TRUE}, the marker names will be diplayed in the
MapChart output as well.}
}
\description{
Write a .mct file of a maplist for external plotting with MapChart software (Voorrips ).
}
\examples{
\dontrun{
data("integrated.maplist")
write.mct(integrated.maplist)}
}
