% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalstd.R
\name{globalstd}
\alias{globalstd}
\title{GlobalStd algorithm with structure/reaction directed analysis}
\usage{
globalstd(
  list,
  rtcutoff = 10,
  ng = NULL,
  corcutoff = NULL,
  digits = 2,
  accuracy = 4,
  freqcutoff = NULL,
  mdrange = NULL,
  sda = FALSE
)
}
\arguments{
\item{list}{a peaks list with mass to charge, retention time and intensity data}

\item{rtcutoff}{cutoff of the distances in cluster, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers, If ng = NULL, 20 percent of RT cluster will be used as ng, default NULL.}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}

\item{freqcutoff}{pmd frequency cutoff for structures or reactions, default NULL. This cutoff will be found by PMD network analysis when it is NULL.}

\item{mdrange}{mass defect range to ignore. Default NULL and c(0.25,0.9) to retain the possible reaction related paired mass}

\item{sda}{logical, option to perform structure/reaction directed analysis, default FALSE.}
}
\value{
list with GlobalStd algorithm processed data.
}
\description{
GlobalStd algorithm with structure/reaction directed analysis
}
\examples{
data(spmeinvivo)
re <- globalstd(spmeinvivo)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotstd}},\code{\link{plotstdsda}},\code{\link{plotstdrt}}
}
