% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imd_anova.R
\name{get_pred_grid}
\alias{get_pred_grid}
\title{Build the prediction grid to compute least squares means.}
\usage{
get_pred_grid(
  group_df,
  main_effect_names,
  covariate_names = NULL,
  fspec = as.formula("~.")
)
}
\arguments{
\item{group_df}{A dataframe with the reserved 'Group' column, and columns for main effects and covariates.}

\item{main_effect_names}{Character vector with the column names of the main effects in group_df.}

\item{covariate_names}{Character vector with the column names of the covariates in group_df.}

\item{fspec}{A formula specification to be passed to \code{\link{model.matrix}} to construct the prediction grid in model matrix form.}
}
\value{
A matrix of the prediction grid
}
\description{
Build the prediction grid to compute least squares means.
}
\author{
Daniel Claborne
}
