% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqsdocs.R
\name{sysreqs_db_match}
\alias{sysreqs_db_match}
\title{Match system requirement descriptions to the database}
\usage{
sysreqs_db_match(specs, sysreqs_platform = NULL)
}
\arguments{
\item{specs}{Character vector of system requirements descriptions.}

\item{sysreqs_platform}{System requirements platform. If \code{NULL}, then the
\code{sysreqs_platform} \eval{man_config_link("configuration option")}
is used, which defaults to the current platform. Set this option if
\eval{.packageName} does not detect your platform correctly.}
}
\value{
Data frame with columns:
\itemize{
\item \code{spec}: the input \code{specs}.
\item \code{sysreq}:  name of the system library or tool.
\item \code{packages}: system packages, list column of character vectors.
Rarely it can be an empty string, e.g. if a \code{pre_install} script
performs the installation.
\item \code{pre_install}: list column of character vectors. Shell script(s) to
run before the installation.
\item \code{post_install}: list column of character vectors. Shell script(s) to
run after the installation.
}
}
\description{
In the usual workflow pkgdepends matches the
\code{SystemRequirements} fields of the \code{DESCRIPTION} files to the database.
}
\details{
The \code{sysreqs_db_match()} function lets you match any string, and it is
mainly useful for debugging.
}
\examples{
\dontshow{if (Sys.getenv("IN_PKGDOWN") == "true") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sysreqs_db_match(
  c("Needs libcurl", "Java, libssl"),
  sysreqs_platform = "ubuntu-22.04"
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other system requirements functions: 
\code{\link{sysreqs_check_installed}()},
\code{\link{sysreqs_db_list}()},
\code{\link{sysreqs_db_update}()},
\code{\link{sysreqs_install_plan}()},
\code{\link{sysreqs_is_supported}()},
\code{\link{sysreqs_list_system_packages}()},
\code{\link{sysreqs_platforms}()}
}
\concept{system requirements functions}
