% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin-upload-download.R
\name{pin_download}
\alias{pin_download}
\alias{pin_upload}
\title{Upload and download files to and from a board}
\usage{
pin_download(board, name, version = NULL, hash = NULL, ...)

pin_upload(
  board,
  paths,
  name = NULL,
  ...,
  title = NULL,
  description = NULL,
  metadata = NULL,
  tags = NULL,
  urls = NULL
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[=pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{hash}{Specify a hash to verify that you get exactly the dataset that
you expect. You can find the hash of an existing pin by looking for
\code{pin_hash} in \code{\link[=pin_meta]{pin_meta()}}.}

\item{...}{Additional arguments passed on to methods for a specific board.}

\item{paths}{A character vector of file paths to upload to \code{board}.}

\item{title}{A title for the pin; most important for shared boards so that
others can understand what the pin contains. If omitted, a brief
description of the contents will be automatically generated.}

\item{description}{A detailed description of the pin contents.}

\item{metadata}{A list containing additional metadata to store with the pin.
When retrieving the pin, this will be stored in the \code{user} key, to
avoid potential clashes with the metadata that pins itself uses.}

\item{tags}{A character vector of tags for the pin; most important for
discoverability on shared boards.}

\item{urls}{A character vector of URLs for more info on the pin, such as a
link to a wiki or other documentation.}
}
\value{
\code{pin_download()} returns a character vector of file paths;
\code{pin_upload()} returns the fully qualified name of the new pin, invisibly.
}
\description{
This is a lower-level interface than \code{pin_read()} and \code{pin_write()} that
you can use to pin any file, as opposed to any R object. The path returned
by \code{pin_download()} is a read-only path to a cached file: you should never
attempt to modify this file.
}
\examples{
board <- board_temp()

board \%>\% pin_upload(system.file("CITATION"))
path <- board \%>\% pin_download("CITATION")
path
readLines(path)[1:5]
}
