% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exr-write.R
\name{write_exr}
\alias{write_exr}
\title{Write a numeric array as an EXR image}
\usage{
write_exr(
  arr,
  filename,
  pixel_type = c("half", "float", "uint"),
  channel_names = NULL,
  attrs = exr_attrs(),
  verbosity = 0
)
}
\arguments{
\item{arr}{array representing image}

\item{filename}{filename}

\item{pixel_type}{one of 'half', 'float' or 'double'.  Default: 'half'}

\item{channel_names}{character vector. names of each plane in the array. 
If \code{NULL} then channel names are extracted from the array 
with \code{dimnames(arr)[[3]]}.  If no names are set on the array, 
then channel names defaults to "Y", "RGB" and 
"RGBA" for 1, 3, and 4 plane arrays respectively.  For 
all other array sizes, channel names allocated alphabetically from
'A' to 'Z'}

\item{attrs}{EXR attributes for image. Use \code{\link{exr_attrs}()}}

\item{verbosity}{verbosity. default: 0}
}
\value{
None
}
\description{
Write a numeric array as an EXR image
}
\examples{
orig_file <- system.file("image", "rstats.pfm.bz2", package = "picohdr")
arr <- read_pfm(orig_file)
exr_file <- tempfile(fileext = ".exr")
write_exr(arr, exr_file)
}
