% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv.range.R
\name{inv.range}
\alias{inv.range}
\title{Calculate the inverse of range size}
\usage{
inv.range(x, filename = "", overwrite = FALSE, ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{filename}{character. Output filename}

\item{overwrite}{logical. If TRUE, filename is overwritten}

\item{...}{additional arguments to be passed passed down from a
calling function.}
}
\value{
SpatRaster and numeric
}
\description{
Get range size in square kilometers for all cells that are not
NA, the inverse of range size and the inverse of range size multiplied by
branch length for multiple species using a raster of presence-absence.
}
\examples{
\donttest{
# calculating the inverse of range size
x <- terra::rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
inv.range(x[[5]])
}
}
\author{
Neander Marcel Heming and Gabriela Alves-Ferreira
}
