% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photosynthesis.R
\encoding{UTF-8}
\name{photosynthesis}
\alias{photosynthesis}
\alias{photo}
\title{Simulate C3 photosynthesis}
\usage{
photosynthesis(
  leaf_par,
  enviro_par,
  bake_par,
  constants,
  use_tealeaves,
  progress = TRUE,
  quiet = FALSE,
  assert_units = TRUE,
  check = TRUE,
  parallel = FALSE,
  use_legacy_version = FALSE
)

photo(
  leaf_par,
  enviro_par,
  bake_par,
  constants,
  use_tealeaves,
  quiet = FALSE,
  assert_units = TRUE,
  check = TRUE,
  prepare_for_tleaf = use_tealeaves,
  use_legacy_version = FALSE
)
}
\arguments{
\item{leaf_par}{A list of leaf parameters inheriting class \code{leaf_par}. This can be generated using the \code{make_leafpar} function.}

\item{enviro_par}{A list of environmental parameters inheriting class \code{enviro_par}. This can be generated using the \code{make_enviropar} function.}

\item{bake_par}{A list of temperature response parameters inheriting class \code{bake_par}. This can be generated using the \code{make_bakepar} function.}

\item{constants}{A list of physical constants inheriting class \code{constants}. This can be generated using the \code{make_constants} function.}

\item{use_tealeaves}{Logical. Should leaf energy balance be used to calculate leaf temperature (T_leaf)? If TRUE, \code{\link[tealeaves:tleaves]{tleaf()}} calculates T_leaf. If FALSE, user-defined T_leaf is used. Additional parameters and constants are required, see \code{\link[=make_parameters]{make_parameters()}}.}

\item{progress}{Logical. Should a progress bar be displayed?}

\item{quiet}{Logical. Should messages be displayed?}

\item{assert_units}{Logical. Should parameter \code{units} be checked? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}

\item{check}{Logical. Should arguments checks be done? This is intended to be disabled when \code{\link[=photo]{photo()}} is called from \code{\link[=photosynthesis]{photosynthesis()}} Default is TRUE.}

\item{parallel}{Logical. Should parallel processing be used via \code{\link[furrr:future_map]{furrr::future_map()}}?}

\item{use_legacy_version}{Logical. Should legacy model (<2.1.0) be used? See \href{https://github.com/cdmuir/photosynthesis/blob/master/NEWS.md}{NEWS} for further information. Default is FALSE.}

\item{prepare_for_tleaf}{Logical. Should arguments additional calculations for \code{\link[tealeaves:tleaves]{tleaf()}}? This is intended to be disabled when \code{\link[=photo]{photo()}} is called from \code{\link[=photosynthesis]{photosynthesis()}}. Default is \code{use_tealeaves}.}
}
\value{
A data.frame with the following \code{units} columns \cr

\strong{Inputs:}\tabular{lllll}{
   Symbol \tab R \tab Description \tab Units \tab Default \cr
   \eqn{D_{\mathrm{c},0}} \tab \code{D_c0} \tab diffusion coefficient for CO2 in air at 0 °C \tab m\eqn{^2} / s \tab \eqn{1.29\times 10^{-5}} \cr
   \eqn{D_{\mathrm{h},0}} \tab \code{D_h0} \tab diffusion coefficient for heat in air at 0 °C \tab m\eqn{^2} / s \tab \eqn{1.90\times 10^{-5}} \cr
   \eqn{D_{\mathrm{m},0}} \tab \code{D_m0} \tab diffusion coefficient for momentum in air at 0 °C \tab m\eqn{^2} / s \tab \eqn{1.33\times 10^{-5}} \cr
   \eqn{D_{\mathrm{w},0}} \tab \code{D_w0} \tab diffusion coefficient for water vapor in air at 0 °C \tab m\eqn{^2} / s \tab \eqn{2.12\times 10^{-5}} \cr
   \eqn{\epsilon} \tab \code{epsilon} \tab ratio of water to air molar masses \tab none \tab 0.622 \cr
   \eqn{G} \tab \code{G} \tab gravitational acceleration \tab m / s\eqn{^2} \tab 9.8 \cr
   \eqn{eT} \tab \code{eT} \tab exponent for temperature dependence of diffusion \tab none \tab 1.75 \cr
   \eqn{R} \tab \code{R} \tab ideal gas constant \tab J / mol / K \tab 8.31 \cr
   \eqn{\sigma} \tab \code{sigma} \tab Stephan-Boltzmann constant \tab W / m\eqn{^2} / K\eqn{^4} \tab \eqn{5.67\times 10^{-8}} \cr
   \eqn{f_\mathrm{Sh}} \tab \code{f_sh} \tab function to calculate constant(s) for Sherwood number \tab none \tab NA \cr
   \eqn{f_\mathrm{Nu}} \tab \code{f_nu} \tab function to calculate constant(s) for Nusselt number \tab none \tab NA \cr
   \eqn{D_\mathrm{s,gmc}} \tab \code{Ds_gmc} \tab empirical temperature response parameter \tab J / mol / K \tab 487 \cr
   \eqn{D_\mathrm{s,Jmax}} \tab \code{Ds_Jmax} \tab empirical temperature response parameter \tab J / mol / K \tab 388 \cr
   \eqn{E_\mathrm{a,\Gamma *}} \tab \code{Ea_gammastar} \tab empirical temperature response parameter \tab J / mol \tab 24500 \cr
   \eqn{E_\mathrm{a,gmc}} \tab \code{Ea_gmc} \tab empirical temperature response parameter \tab J / mol \tab 68900 \cr
   \eqn{E_\mathrm{a,Jmax}} \tab \code{Ea_Jmax} \tab empirical temperature response parameter \tab J / mol \tab 56100 \cr
   \eqn{E_\mathrm{a,KC}} \tab \code{Ea_KC} \tab empirical temperature response parameter \tab J / mol \tab 81000 \cr
   \eqn{E_\mathrm{a,KO}} \tab \code{Ea_KO} \tab empirical temperature response parameter \tab J / mol \tab 23700 \cr
   \eqn{E_\mathrm{a,Rd}} \tab \code{Ea_Rd} \tab empirical temperature response parameter \tab J / mol \tab 40400 \cr
   \eqn{E_\mathrm{a,Vcmax}} \tab \code{Ea_Vcmax} \tab empirical temperature response parameter \tab J / mol \tab 52200 \cr
   \eqn{E_\mathrm{a,Vtpu}} \tab \code{Ea_Vtpu} \tab empirical temperature response parameter \tab J / mol \tab 52200 \cr
   \eqn{E_\mathrm{d,gmc}} \tab \code{Ed_gmc} \tab empirical temperature response parameter \tab J / mol \tab 149000 \cr
   \eqn{E_\mathrm{d,Jmax}} \tab \code{Ed_Jmax} \tab empirical temperature response parameter \tab J / mol \tab 121000 \cr
   \eqn{C_\mathrm{air}} \tab \code{C_air} \tab atmospheric CO2 concentration \tab umol/mol \tab 420 \cr
   \eqn{O} \tab \code{O} \tab atmospheric O2 concentration \tab mol/mol \tab 0.21 \cr
   \eqn{P} \tab \code{P} \tab atmospheric pressure \tab kPa \tab 101 \cr
   \eqn{\mathrm{PPFD}} \tab \code{PPFD} \tab photosynthetic photon flux density \tab umol / m\eqn{^2} / s \tab 1500 \cr
   \eqn{\mathrm{RH}} \tab \code{RH} \tab relative humidity \tab none \tab 0.5 \cr
   \eqn{u} \tab \code{wind} \tab windspeed \tab m / s \tab 2 \cr
   \eqn{d} \tab \code{leafsize} \tab leaf characteristic dimension \tab m \tab 0.1 \cr
   \eqn{\Gamma*_{25}} \tab \code{gamma_star25} \tab chloroplastic CO2 compensation point (25 °C) \tab umol/mol \tab 37.9 \cr
   \eqn{g_\mathrm{mc,25}} \tab \code{g_mc25} \tab mesophyll conductance to CO2 (25 °C) \tab mol / m\eqn{^2} / s \tab 0.4 \cr
   \eqn{g_\mathrm{sc}} \tab \code{g_sc} \tab stomatal conductance to CO2 \tab mol / m\eqn{^2} / s \tab 0.4 \cr
   \eqn{g_\mathrm{uc}} \tab \code{g_uc} \tab cuticular conductance to CO2 \tab mol / m\eqn{^2} / s \tab 0.01 \cr
   \eqn{J_\mathrm{max,25}} \tab \code{J_max25} \tab potential electron transport (25 °C) \tab umol / m\eqn{^2} / s \tab 200 \cr
   \eqn{k_\mathrm{mc}} \tab \code{k_mc} \tab partition of g_mc to lower mesophyll \tab none \tab 1 \cr
   \eqn{k_\mathrm{sc}} \tab \code{k_sc} \tab partition of g_sc to lower surface \tab none \tab 1 \cr
   \eqn{k_\mathrm{uc}} \tab \code{k_uc} \tab partition of g_uc to lower surface \tab none \tab 1 \cr
   \eqn{K_\mathrm{C,25}} \tab \code{K_C25} \tab Michaelis constant for carboxylation (25 °C) \tab umol / mol \tab 268 \cr
   \eqn{K_\mathrm{O,25}} \tab \code{K_O25} \tab Michaelis constant for oxygenation (25 °C) \tab umol / mol \tab 165000 \cr
   \eqn{\phi_J} \tab \code{phi_J} \tab initial slope of the response of J to PPFD \tab none \tab 0.331 \cr
   \eqn{R_\mathrm{d,25}} \tab \code{R_d25} \tab nonphotorespiratory CO2 release (25 °C) \tab umol / m\eqn{^2} / s \tab 2 \cr
   \eqn{\theta_J} \tab \code{theta_J} \tab curvature factor for light-response curve \tab none \tab 0.825 \cr
   \eqn{T_\mathrm{leaf}} \tab \code{T_leaf} \tab leaf temperature \tab K \tab 298 \cr
   \eqn{V_\mathrm{c,max,25}} \tab \code{V_cmax25} \tab maximum rate of carboxylation (25 °C) \tab umol / m\eqn{^2} / s \tab 150 \cr
   \eqn{V_\mathrm{tpu,25}} \tab \code{V_tpu25} \tab rate of triose phosphate utilization (25 °C) \tab umol / m\eqn{^2} / s \tab 200 \cr
   \eqn{\delta_\mathrm{ias,lower}} \tab \code{delta_ias_lower} \tab effective distance through lower internal airspace \tab um \tab NA \cr
   \eqn{\delta_\mathrm{ias,upper}} \tab \code{delta_ias_upper} \tab effective distance through upper internal airspace \tab um \tab NA \cr
   \eqn{A_\mathrm{mes} / A} \tab \code{A_mes_A} \tab mesophyll surface area per unit leaf area \tab none \tab NA \cr
   \eqn{g_\mathrm{liq,c,25}} \tab \code{g_liqc25} \tab liquid-phase conductance to CO2 (25 °C) \tab mol / m\eqn{^2} / s \tab NA \cr
}


\strong{Baked Inputs:}\tabular{lllll}{
   Symbol \tab R \tab Description \tab Units \tab Default \cr
   \eqn{\Gamma*} \tab \code{gamma_star} \tab chloroplastic CO2 compensation point (T_leaf) \tab umol/mol \tab NA \cr
   \eqn{g_\mathrm{mc}} \tab \code{g_mc} \tab mesophyll conductance to CO2 (T_leaf) \tab mol / m\eqn{^2} / s \tab NA \cr
   \eqn{J_\mathrm{max}} \tab \code{J_max} \tab potential electron transport (T_leaf) \tab umol / m\eqn{^2} / s \tab NA \cr
   \eqn{K_\mathrm{C}} \tab \code{K_C} \tab Michaelis constant for carboxylation (T_leaf) \tab umol / mol \tab NA \cr
   \eqn{K_\mathrm{O}} \tab \code{K_O} \tab Michaelis constant for oxygenation (T_leaf) \tab umol / mol \tab NA \cr
   \eqn{R_\mathrm{d}} \tab \code{R_d} \tab nonphotorespiratory CO2 release (T_leaf) \tab umol / m\eqn{^2} / s \tab NA \cr
   \eqn{V_\mathrm{c,max}} \tab \code{V_cmax} \tab maximum rate of carboxylation (T_leaf) \tab umol / m\eqn{^2} / s \tab NA \cr
   \eqn{V_\mathrm{tpu}} \tab \code{V_tpu} \tab rate of triose phosphate utilisation (T_leaf) \tab umol / m\eqn{^2} / s \tab NA \cr
   \eqn{g_\mathrm{liq,c}} \tab \code{g_liqc} \tab liquid-phase conductance to CO2 (T_leaf) \tab mol / m\eqn{^2} / s \tab NA \cr
   \eqn{g_\mathrm{ias,c,lower}} \tab \code{g_iasc_lower} \tab internal airspace conductance to CO2 in lower part of leaf (T_leaf) \tab mol / m\eqn{^2} / s \tab NA \cr
   \eqn{g_\mathrm{ias,c,upper}} \tab \code{g_iasc_upper} \tab internal airspace conductance to CO2 in upper part of leaf (T_leaf) \tab mol / m\eqn{^2} / s \tab NA \cr
}


\tabular{ll}{

\strong{Output:} \tab \cr
\cr
\code{A} \tab photosynthetic rate at \code{C_chl} (\eqn{\mu}mol CO2 / m\eqn{^2} / s) \cr
\code{C_chl} \tab chloroplastic CO2 concentration where \code{A_supply} intersects \code{A_demand} (\eqn{mu}mol / mol) \cr
\code{C_i} \tab intercellular CO2 concentration where \code{A_supply} intersects \code{A_demand} (\eqn{mu}mol / mol) \cr
\code{g_tc} \tab total conductance to CO2 at \code{T_leaf} (mol / m\eqn{^2} / s)) \cr
\code{value} \tab \code{A_supply} - \code{A_demand} (\eqn{\mu}mol / (m\eqn{^2} s)) at \code{C_chl} \cr
\code{convergence} \tab convergence code (0 = converged)
}
}
\description{
\code{photosynthesis}: simulate C3 photosynthesis over multiple parameter sets

\code{photo}: simulate C3 photosynthesis over a single parameter set
}
\details{
\code{photo}: This function takes simulates photosynthetic rate using the Farquhar-von Caemmerer-Berry (\code{\link[=FvCB]{FvCB()}}) model of C3 photosynthesis for single combined set of leaf parameters (\code{\link[=leaf_par]{leaf_par()}}), environmental parameters (\code{\link[=enviro_par]{enviro_par()}}), and physical constants (\code{\link[=constants]{constants()}}). Leaf parameters are provided at reference temperature (25 °C) and then "baked" to the appropriate leaf temperature using temperature response functions (see \code{\link[=bake]{bake()}}). \cr
\cr
\code{photosynthesis}: This function uses \code{photo} to simulate photosynthesis over multiple parameter sets that are generated using \code{\link[purrr:cross]{cross_df()}}. \cr
}
\examples{
# Single parameter set with 'photo'

bake_par = make_bakepar()
constants = make_constants(use_tealeaves = FALSE)
enviro_par = make_enviropar(use_tealeaves = FALSE)
leaf_par = make_leafpar(use_tealeaves = FALSE)
photo(leaf_par, enviro_par, bake_par, constants,
  use_tealeaves = FALSE
)

# Multiple parameter sets with 'photosynthesis'

leaf_par = make_leafpar(
  replace = list(
    T_leaf = set_units(c(293.14, 298.15), "K")
  ), use_tealeaves = FALSE
)
photosynthesis(leaf_par, enviro_par, bake_par, constants,
  use_tealeaves = FALSE
)
}
