% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disattenuationCorrelation.R
\name{disattenuationCorrelation}
\alias{disattenuationCorrelation}
\title{Disattenuation of Observed Correlation Due to Measurement Error.}
\usage{
disattenuationCorrelation(
  observedAssociation,
  reliabilityOfPredictor,
  reliabilityOfCriterion
)
}
\arguments{
\item{observedAssociation}{Magnitude of observed association (\emph{r}
value).}

\item{reliabilityOfPredictor}{Reliability of predictor (from 0 to 1).}

\item{reliabilityOfCriterion}{Reliability of criterion/outcome (from 0 to 1).}
}
\value{
True association between predictor and criterion.
}
\description{
Estimate the true association between the predictor and criterion after
accounting for the degree to which a true correlation is attenuated due to
measurement error.
}
\details{
Estimate the true association between the predictor and criterion after
accounting for the degree to which a true correlation is attenuated due to
random measurement error (unreliability).
}
\examples{
disattenuationCorrelation(
  observedAssociation = .7,
  reliabilityOfPredictor = .9,
  reliabilityOfCriterion = .85)
}
\seealso{
Other correlation: 
\code{\link{attenuationCorrelation}()}
}
\concept{correlation}
