\name{orbit}
\alias{orbit}
\alias{orbit_single}
\title{
Orbits of integers
}
\description{
Finds the orbit of a given integer
}
\usage{
orbit_single(c1,n1)
orbit(cyc,n)
}
\arguments{
  \item{c1,n1}{In (low-level) function \code{orbit_single()}, a cyclist
    and an integer vector respectively}
  \item{cyc,n}{In (vectorized) function \code{orbit()}, \code{cyc} is
    coerced to a cycle, and \code{n} is an integer vector}
}
\value{

  Given a cyclist \code{c1} and integer \code{n1}, function
  \code{orbit_single()} returns the single cycle containing integer
  \code{n1}.  This is a low-level function, not intended for the
  end-user.

  Function \code{orbit()} is the vectorized equivalent of
  \code{orbit_single()}.  Vectorization is inherited from
  \code{cbind()}.

  The orbit of a fixed point \eqn{p} is \eqn{\left\lbrace
  p\right\rbrace}{omitted}; the code uses an ugly hack to ensure that
  this is the case.
  
}



\author{Robin K. S. Hankin}
\note{

  Orbits are useful in a more general group theoretic context.  Consider
  a finite group \eqn{G} acting on a set \eqn{X}, that is

  \deqn{\alpha\colon G\times X\longrightarrow X.}{omitted.}

  Writing \eqn{\alpha(g,x)=gx}{omitted}, we define
  \eqn{\alpha}{omitted} to be a \dfn{group action} if \eqn{ex=x}
  and \eqn{g(hx)=(gh)x} where \eqn{g,h\in G}{omitted} and
  \eqn{e} is the group identity.  For any \eqn{x\in X}{omitted} we
  define the \dfn{orbit} \eqn{Gx} of \eqn{x} to be the set of
  elements of \eqn{X} to which \eqn{x} can be moved by an element
  of \eqn{G}.  Symbolically:

  \deqn{Gx=\left\lbrace gx\colon g\in G\right\rbrace}{omitted}

  Now, we abuse notation slightly.  In the context of permutation
  groups, we consider a fixed permutation \eqn{\sigma}{omitted}.  We
  consider the group \eqn{G=\left\langle\sigma\right\rangle}{omitted},
  that is, the group \emph{generated by} \eqn{\sigma}{omitted}; the
  group action is that of \eqn{G} on set \eqn{X=\left\lbrace
  1,2,\ldots,n\right\rbrace}{X={1,2,...,n}} with the obvious definition
  \eqn{\sigma x=\sigma(x)}{omitted} for \eqn{\sigma\in G}{omitted}
  and \eqn{x\in X}{omitted}.  This clearly is a group action as
  \eqn{\operatorname{id}(x)=x}{id(x)=x} and \eqn{\sigma(\mu
  x)=(\sigma\mu)x}{omitted}.

  \deqn{Gx=\bigcup_{i\in\mathbb{Z}}\sigma^i(x)}{omitted}

  Expressing \eqn{\sigma}{omitted} in cycle form makes it easy to see
  that the orbit of any element \eqn{x} of \eqn{X} is just the
  other members in the cycle containing \eqn{x}.  For example,
  consider \eqn{\sigma=(26)(348)}{omitted} and \eqn{x=4}.
  Then

  \deqn{G=\left\langle(26)(348)\right\rangle =
    \bigcup_{i\in\mathbb{Z}}[(26)(348)]^i}{omitted}

  Because we are only interested in the effects on \eqn{x=4}, we only
  need to consider the cycle \eqn{(348)}: this is the only cycle that
  affects \eqn{x=4}, and the \eqn{(26)} cycle may be ignored as it
  does not affect element 4.  So

  \deqn{G4=\bigcup_{i\in\mathbb{Z}}(348)^i(4)=\left\lbrace
  3,4,8\right\rbrace}{omitted}

  [observe the slight notational abuse above: \dQuote{\eqn{(348)}}
  means \dQuote{the function \eqn{f(\cdot)}{f(.)} with
  \eqn{f(3)=4}, \eqn{f(4)=8}, and \eqn{f(8)=3}}].

  }
\seealso{
\code{\link{fixed}}
}
\examples{

orbit(as.cycle("(123)"),1:5)
orbit(as.cycle(c("(12)","(123)(45)","(2345)")),1)
orbit(as.cycle(c("(12)","(123)(45)","(2345)")),1:3)

data(megaminx)
orbit(megaminx,13)

}
\keyword{symbolmath}
