% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadableReactTable.R
\name{downloadableReactTableUI}
\alias{downloadableReactTableUI}
\title{downloadableReactTable module UI function}
\usage{
downloadableReactTableUI(id, downloadtypes = NULL, hovertext = NULL)
}
\arguments{
\item{id}{character id for the object}

\item{downloadtypes}{vector of values for data download types}

\item{hovertext}{download button tooltip hover text}
}
\value{
list of downloadFileButton UI and reactable table and hidden inputs for contentHeight option
}
\description{
downloadableReactTable module is extending \code{?reactable} package table functions by creating
a custom high-functionality table paired with \link[periscope2]{downloadFile} button.
The table has the following default functionality:search, highlight functionality, infinite scrolling, sorting by columns and
returns a reactive dataset of selected items and table current state.
}
\details{
\link[periscope2]{downloadFile} button will be hidden if \code{downloadableReactTableUI} parameter
\code{downloadtypes} is empty
}
\section{Table Features}{

\itemize{
\item Consistent styling of the table
\item downloadFile module button functionality built-in to the table (it will be shown only if downloadtypes is defined)
\item Ability to show different data from the download data
\item Table is automatically fit to the window size with infinite
y-scrolling
\item Table search functionality including highlighting built-in
\item Multi-select built in, including reactive feedback on which table
items are selected
}
}

\section{Example}{

\code{downloadableReactTableUI("mytableID", c("csv", "tsv"),
"Click Here")}
}

\section{Notes}{

When there are no rows to download in any of the linked downloaddatafxns the
button will be hidden as there is nothing to download.
}

\section{Shiny Usage}{

Call this function at the place in ui.R where the table should be placed.

Paired with a call to \code{downloadableReactTable(id, ...)}
in server.R
}

\examples{
if (interactive()) {
 library(shiny)
 library(periscope2)
 library(reactable)

 shinyApp(
     ui = fluidPage(fluidRow(column(
         width = 12,
         downloadableReactTableUI(
             id            = "object_id1",
             downloadtypes = c("csv", "tsv"),
             hovertext     = "Download the data here!")))),
     server = function(input, output) {
         table_state <- downloadableReactTable(
             id                 = "object_id1",
             table_data         = reactiveVal(iris),
             download_data_fxns = list(csv = reactiveVal(iris), tsv = reactiveVal(iris)),
             selection_mode     = "multiple",
             pre_selected_rows  = function() {c(1, 3, 5)},
             table_options      = list(columns = list(
                 Sepal.Length = colDef(name = "Sepal Length"),
                 Sepal.Width  = colDef(filterable = TRUE),
                 Petal.Length = colDef(show = FALSE),
                 Petal.Width  = colDef(defaultSortOrder = "desc")),
                 showSortable = TRUE,
                 theme = reactableTheme(
                     borderColor = "#dfe2e5",
                     stripedColor = "#f6f8fa",
                     highlightColor = "#f0f5f9",
                     cellPadding = "8px 12px")))

        observeEvent(table_state(), { print(table_state()) })
    })
}

}
\seealso{
\link[periscope2]{downloadableReactTable}

\link[periscope2]{downloadFile}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadablePlot}
}
