% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco_micro.R
\name{ncm}
\alias{ncm}
\alias{plot.ncm_res}
\title{Sloan Neutral Model}
\usage{
ncm(otutab, model = "nls")

\method{plot}{ncm_res}(
  x,
  mycols = c(Above = "#069870", Below = "#e29e02", In = "#1e353a"),
  text_position = NULL,
  pie_text_params = list(size = 2.5),
  ...
)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{model}{fit method, one of "nls","mle"}

\item{x}{a ncm_res object}

\item{mycols}{mycols}

\item{text_position}{text_position}

\item{pie_text_params}{pie text parameters}

\item{...}{add}
}
\value{
ncm_res

ggplot
}
\description{
Sloan Neutral Model

Plot ncm_res
}
\examples{
\donttest{
if (requireNamespace("Hmisc") && requireNamespace("minpack.lm")) {
  data(otutab, package = "pcutils")
  ncm(otutab) -> ncm_res
  plot(ncm_res)
}
}
}
\references{
Sloan, W. TRUE. et al. (2006) Quantifying the roles of immigration and chance in shaping prokaryote community structure. Environmental Microbiology 8, 732–740.
}
