% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_analyse.R
\name{b_analyse}
\alias{b_analyse}
\alias{b_analyse.data.frame}
\title{Beta_diversity Ordination: dimensionality reduction}
\usage{
b_analyse(otutab, ...)

\method{b_analyse}{data.frame}(
  otutab,
  norm = TRUE,
  method = c("pca"),
  group = NULL,
  dist = "bray",
  ndim = 2,
  scale = FALSE,
  ...
)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{...}{add}

\item{norm}{should normalized or not? (hellinger)}

\item{method}{one of "pca","pcoa","ca","dca","nmds","plsda","tsne","umap","lda","all"}

\item{group}{if needed, give a group vector}

\item{dist}{if use pcoa or nmds, your can choose a dist method (default: bray) or input a distance matrix.}

\item{ndim}{how many dimension be kept? (default:2). 3 for b_res_3d()}

\item{scale}{scale, default: FALSE}
}
\value{
b_res object
}
\description{
Species abundance data can be preprocessed with Hellinger transformation or chord transformation data before PCA analysis. Because the Hellinger distance or chord distance with-without data is equal to \eqn{\sqrt2\sqrt{1-Ochiai\ similarity}}, therefore, the sorting diagram (type 1 scale) of PCA analysis after Hellinger transformation or chord transformation with-without data is internal sample The distance between the squares is the Ochiai distance. \eqn{\sqrt2\sqrt{1-Ochiai\ similarity}} is a distance measure, which is also suitable for the analysis of species data. The processed data is then used for pca without norm.
}
\examples{
data(otutab, package = "pcutils")
b_analyse(otutab, method = "pca") -> b_res
plot(b_res, "Group", metadata)
}
\references{
\url{https://www.jianshu.com/p/9694c0b6302d}
\url{https://zhuanlan.zhihu.com/p/25501130}
}
