% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{eks}
\alias{eks}
\title{Amazon Elastic Kubernetes Service}
\usage{
eks(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that
makes it easy for you to run Kubernetes on Amazon Web Services without
needing to setup or maintain your own Kubernetes control plane.
Kubernetes is an open-source system for automating the deployment,
scaling, and management of containerized applications.

Amazon EKS runs up-to-date versions of the open-source Kubernetes
software, so you can use all the existing plugins and tooling from the
Kubernetes community. Applications running on Amazon EKS are fully
compatible with applications running on any standard Kubernetes
environment, whether running in on-premises data centers or public
clouds. This means that you can easily migrate any standard Kubernetes
application to Amazon EKS without any code modification required.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- eks(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.compute:eks_associate_access_policy]{associate_access_policy} \tab Associates an access policy and its scope to an access entry\cr
\link[paws.compute:eks_associate_encryption_config]{associate_encryption_config} \tab Associates an encryption configuration to an existing cluster\cr
\link[paws.compute:eks_associate_identity_provider_config]{associate_identity_provider_config} \tab Associates an identity provider configuration to a cluster\cr
\link[paws.compute:eks_create_access_entry]{create_access_entry} \tab Creates an access entry\cr
\link[paws.compute:eks_create_addon]{create_addon} \tab Creates an Amazon EKS add-on\cr
\link[paws.compute:eks_create_cluster]{create_cluster} \tab Creates an Amazon EKS control plane\cr
\link[paws.compute:eks_create_eks_anywhere_subscription]{create_eks_anywhere_subscription} \tab Creates an EKS Anywhere subscription\cr
\link[paws.compute:eks_create_fargate_profile]{create_fargate_profile} \tab Creates an Fargate profile for your Amazon EKS cluster\cr
\link[paws.compute:eks_create_nodegroup]{create_nodegroup} \tab Creates a managed node group for an Amazon EKS cluster\cr
\link[paws.compute:eks_create_pod_identity_association]{create_pod_identity_association} \tab Creates an EKS Pod Identity association between a service account in an Amazon EKS cluster and an IAM role with EKS Pod Identity\cr
\link[paws.compute:eks_delete_access_entry]{delete_access_entry} \tab Deletes an access entry\cr
\link[paws.compute:eks_delete_addon]{delete_addon} \tab Deletes an Amazon EKS add-on\cr
\link[paws.compute:eks_delete_cluster]{delete_cluster} \tab Deletes an Amazon EKS cluster control plane\cr
\link[paws.compute:eks_delete_eks_anywhere_subscription]{delete_eks_anywhere_subscription} \tab Deletes an expired or inactive subscription\cr
\link[paws.compute:eks_delete_fargate_profile]{delete_fargate_profile} \tab Deletes an Fargate profile\cr
\link[paws.compute:eks_delete_nodegroup]{delete_nodegroup} \tab Deletes a managed node group\cr
\link[paws.compute:eks_delete_pod_identity_association]{delete_pod_identity_association} \tab Deletes a EKS Pod Identity association\cr
\link[paws.compute:eks_deregister_cluster]{deregister_cluster} \tab Deregisters a connected cluster to remove it from the Amazon EKS control plane\cr
\link[paws.compute:eks_describe_access_entry]{describe_access_entry} \tab Describes an access entry\cr
\link[paws.compute:eks_describe_addon]{describe_addon} \tab Describes an Amazon EKS add-on\cr
\link[paws.compute:eks_describe_addon_configuration]{describe_addon_configuration} \tab Returns configuration options\cr
\link[paws.compute:eks_describe_addon_versions]{describe_addon_versions} \tab Describes the versions for an add-on\cr
\link[paws.compute:eks_describe_cluster]{describe_cluster} \tab Describes an Amazon EKS cluster\cr
\link[paws.compute:eks_describe_cluster_versions]{describe_cluster_versions} \tab Lists available Kubernetes versions for Amazon EKS clusters\cr
\link[paws.compute:eks_describe_eks_anywhere_subscription]{describe_eks_anywhere_subscription} \tab Returns descriptive information about a subscription\cr
\link[paws.compute:eks_describe_fargate_profile]{describe_fargate_profile} \tab Describes an Fargate profile\cr
\link[paws.compute:eks_describe_identity_provider_config]{describe_identity_provider_config} \tab Describes an identity provider configuration\cr
\link[paws.compute:eks_describe_insight]{describe_insight} \tab Returns details about an insight that you specify using its ID\cr
\link[paws.compute:eks_describe_nodegroup]{describe_nodegroup} \tab Describes a managed node group\cr
\link[paws.compute:eks_describe_pod_identity_association]{describe_pod_identity_association} \tab Returns descriptive information about an EKS Pod Identity association\cr
\link[paws.compute:eks_describe_update]{describe_update} \tab Describes an update to an Amazon EKS resource\cr
\link[paws.compute:eks_disassociate_access_policy]{disassociate_access_policy} \tab Disassociates an access policy from an access entry\cr
\link[paws.compute:eks_disassociate_identity_provider_config]{disassociate_identity_provider_config} \tab Disassociates an identity provider configuration from a cluster\cr
\link[paws.compute:eks_list_access_entries]{list_access_entries} \tab Lists the access entries for your cluster\cr
\link[paws.compute:eks_list_access_policies]{list_access_policies} \tab Lists the available access policies\cr
\link[paws.compute:eks_list_addons]{list_addons} \tab Lists the installed add-ons\cr
\link[paws.compute:eks_list_associated_access_policies]{list_associated_access_policies} \tab Lists the access policies associated with an access entry\cr
\link[paws.compute:eks_list_clusters]{list_clusters} \tab Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Amazon Web Services Region\cr
\link[paws.compute:eks_list_eks_anywhere_subscriptions]{list_eks_anywhere_subscriptions} \tab Displays the full description of the subscription\cr
\link[paws.compute:eks_list_fargate_profiles]{list_fargate_profiles} \tab Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region\cr
\link[paws.compute:eks_list_identity_provider_configs]{list_identity_provider_configs} \tab Lists the identity provider configurations for your cluster\cr
\link[paws.compute:eks_list_insights]{list_insights} \tab Returns a list of all insights checked for against the specified cluster\cr
\link[paws.compute:eks_list_nodegroups]{list_nodegroups} \tab Lists the managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region\cr
\link[paws.compute:eks_list_pod_identity_associations]{list_pod_identity_associations} \tab List the EKS Pod Identity associations in a cluster\cr
\link[paws.compute:eks_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an Amazon EKS resource\cr
\link[paws.compute:eks_list_updates]{list_updates} \tab Lists the updates associated with an Amazon EKS resource in your Amazon Web Services account, in the specified Amazon Web Services Region\cr
\link[paws.compute:eks_register_cluster]{register_cluster} \tab Connects a Kubernetes cluster to the Amazon EKS control plane\cr
\link[paws.compute:eks_tag_resource]{tag_resource} \tab Associates the specified tags to an Amazon EKS resource with the specified resourceArn\cr
\link[paws.compute:eks_untag_resource]{untag_resource} \tab Deletes specified tags from an Amazon EKS resource\cr
\link[paws.compute:eks_update_access_entry]{update_access_entry} \tab Updates an access entry\cr
\link[paws.compute:eks_update_addon]{update_addon} \tab Updates an Amazon EKS add-on\cr
\link[paws.compute:eks_update_cluster_config]{update_cluster_config} \tab Updates an Amazon EKS cluster configuration\cr
\link[paws.compute:eks_update_cluster_version]{update_cluster_version} \tab Updates an Amazon EKS cluster to the specified Kubernetes version\cr
\link[paws.compute:eks_update_eks_anywhere_subscription]{update_eks_anywhere_subscription} \tab Update an EKS Anywhere Subscription\cr
\link[paws.compute:eks_update_nodegroup_config]{update_nodegroup_config} \tab Updates an Amazon EKS managed node group configuration\cr
\link[paws.compute:eks_update_nodegroup_version]{update_nodegroup_version} \tab Updates the Kubernetes version or AMI version of an Amazon EKS managed node group\cr
\link[paws.compute:eks_update_pod_identity_association]{update_pod_identity_association} \tab Updates a EKS Pod Identity association
}
}

\examples{
\dontrun{
svc <- eks()
# The following example creates an Amazon EKS cluster called prod.
svc$create_cluster(
  version = "1.10",
  name = "prod",
  clientRequestToken = "1d2129a1-3d38-460a-9756-e5b91fddb951",
  resourcesVpcConfig = list(
    securityGroupIds = list(
      "sg-6979fe18"
    ),
    subnetIds = list(
      "subnet-6782e71e",
      "subnet-e7e761ac"
    )
  ),
  roleArn = "arn:aws:iam::012345678910:role/eks-service-role-AWSServiceRole..."
)
}

}
