% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_access_grant}
\alias{s3control_create_access_grant}
\title{Creates an access grant that gives a grantee access to your S3 data}
\usage{
s3control_create_access_grant(
  AccountId,
  AccessGrantsLocationId,
  AccessGrantsLocationConfiguration = NULL,
  Grantee,
  Permission,
  ApplicationArn = NULL,
  S3PrefixType = NULL,
  Tags = NULL
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID of the S3 Access Grants instance.}

\item{AccessGrantsLocationId}{[required] The ID of the registered location to which you are granting access. S3
Access Grants assigns this ID when you register the location. S3 Access
Grants assigns the ID \code{default} to the default location \verb{s3://} and
assigns an auto-generated ID to other locations that you register.

If you are passing the \code{default} location, you cannot create an access
grant for the entire default location. You must also specify a bucket or
a bucket and prefix in the \code{Subprefix} field.}

\item{AccessGrantsLocationConfiguration}{The configuration options of the grant location. The grant location is
the S3 path to the data to which you are granting access. It contains
the \code{S3SubPrefix} field. The grant scope is the result of appending the
subprefix to the location scope of the registered location.}

\item{Grantee}{[required] The user, group, or role to which you are granting access. You can grant
access to an IAM user or role. If you have added your corporate
directory to Amazon Web Services IAM Identity Center and associated your
Identity Center instance with your S3 Access Grants instance, the
grantee can also be a corporate directory user or group.}

\item{Permission}{[required] The type of access that you are granting to your S3 data, which can be
set to one of the following values:
\itemize{
\item \code{READ} – Grant read-only access to the S3 data.
\item \code{WRITE} – Grant write-only access to the S3 data.
\item \code{READWRITE} – Grant both read and write access to the S3 data.
}}

\item{ApplicationArn}{The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity
Center application associated with your Identity Center instance. If an
application ARN is included in the request to create an access grant,
the grantee can only access the S3 data through this application.}

\item{S3PrefixType}{The type of \code{S3SubPrefix}. The only possible value is \code{Object}. Pass
this value if the access grant scope is an object. Do not pass this
value if the access grant scope is a bucket or a bucket and a prefix.}

\item{Tags}{The Amazon Web Services resource tags that you are adding to the access
grant. Each tag is a label consisting of a user-defined key and value.
Tags can help you manage, identify, organize, search for, and filter
resources.}
}
\description{
Creates an access grant that gives a grantee access to your S3 data. The grantee can be an IAM user or role or a directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data. You can create an S3 Access Grants instance using the \code{\link[=s3control_create_access_grants_instance]{create_access_grants_instance}}. You must also have registered at least one S3 data location in your S3 Access Grants instance using \code{\link[=s3control_create_access_grants_location]{create_access_grants_location}}.

See \url{https://www.paws-r-sdk.com/docs/s3control_create_access_grant/} for full documentation.
}
\keyword{internal}
