% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_query_logging_config}
\alias{route53_create_query_logging_config}
\title{Creates a configuration for DNS query logging}
\usage{
route53_create_query_logging_config(HostedZoneId, CloudWatchLogsLogGroupArn)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the hosted zone that you want to log queries for. You can log
queries only for public hosted zones.}

\item{CloudWatchLogsLogGroupArn}{[required] The Amazon Resource Name (ARN) for the log group that you want to Amazon
Route 53 to send query logs to. This is the format of the ARN:

arn:aws:logs:\emph{region}:\emph{account-id}:log-group:\emph{log_group_name}

To get the ARN for a log group, you can use the CloudWatch console, the
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html}{DescribeLogGroups}
API action, the
\href{https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html}{describe-log-groups}
command, or the applicable command in one of the Amazon Web Services
SDKs.}
}
\description{
Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.

See \url{https://www.paws-r-sdk.com/docs/route53_create_query_logging_config/} for full documentation.
}
\keyword{internal}
