% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_label_parameter_version}
\alias{ssm_label_parameter_version}
\title{A parameter label is a user-defined alias to help you manage different
versions of a parameter}
\usage{
ssm_label_parameter_version(Name, ParameterVersion = NULL, Labels)
}
\arguments{
\item{Name}{[required] The parameter name on which you want to attach one or more labels.

You can't enter the Amazon Resource Name (ARN) for a parameter, only the
parameter name itself.}

\item{ParameterVersion}{The specific version of the parameter on which you want to attach one or
more labels. If no version is specified, the system attaches the label
to the latest version.}

\item{Labels}{[required] One or more labels to attach to the specified parameter version.}
}
\description{
A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions.

See \url{https://www.paws-r-sdk.com/docs/ssm_label_parameter_version/} for full documentation.
}
\keyword{internal}
