% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_calendar_state}
\alias{ssm_get_calendar_state}
\title{Gets the state of a Amazon Web Services Systems Manager change calendar
at the current time or a specified time}
\usage{
ssm_get_calendar_state(CalendarNames, AtTime = NULL)
}
\arguments{
\item{CalendarNames}{[required] The names or Amazon Resource Names (ARNs) of the Systems Manager
documents (SSM documents) that represent the calendar entries for which
you want to get the state.}

\item{AtTime}{(Optional) The specific time for which you want to get calendar state
information, in \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601}
format. If you don't specify a value or \code{AtTime}, the current time is
used.}
}
\description{
Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If you specify a time, \code{\link[=ssm_get_calendar_state]{get_calendar_state}} returns the state of the calendar at that specific time, and returns the next time that the change calendar state will transition. If you don't specify a time, \code{\link[=ssm_get_calendar_state]{get_calendar_state}} uses the current time. Change Calendar entries have two possible states: \code{OPEN} or \code{CLOSED}.

See \url{https://www.paws-r-sdk.com/docs/ssm_get_calendar_state/} for full documentation.
}
\keyword{internal}
