% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_maintenance_window}
\alias{ssm_create_maintenance_window}
\title{Creates a new maintenance window}
\usage{
ssm_create_maintenance_window(
  Name,
  Description = NULL,
  StartDate = NULL,
  EndDate = NULL,
  Schedule,
  ScheduleTimezone = NULL,
  ScheduleOffset = NULL,
  Duration,
  Cutoff,
  AllowUnassociatedTargets,
  ClientToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the maintenance window.}

\item{Description}{An optional description for the maintenance window. We recommend
specifying a description to help you organize your maintenance windows.}

\item{StartDate}{The date and time, in ISO-8601 Extended format, for when you want the
maintenance window to become active. \code{StartDate} allows you to delay
activation of the maintenance window until the specified future date.

When using a rate schedule, if you provide a start date that occurs in
the past, the current date and time are used as the start date.}

\item{EndDate}{The date and time, in ISO-8601 Extended format, for when you want the
maintenance window to become inactive. \code{EndDate} allows you to set a
date and time in the future when the maintenance window will no longer
run.}

\item{Schedule}{[required] The schedule of the maintenance window in the form of a cron or rate
expression.}

\item{ScheduleTimezone}{The time zone that the scheduled maintenance window executions are based
on, in Internet Assigned Numbers Authority (IANA) format. For example:
"America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
the \href{https://www.iana.org/time-zones}{Time Zone Database} on the IANA
website.}

\item{ScheduleOffset}{The number of days to wait after the date and time specified by a cron
expression before running the maintenance window.

For example, the following cron expression schedules a maintenance
window to run on the third Tuesday of every month at 11:30 PM.

\verb{cron(30 23 ? * TUE#3 *)}

If the schedule offset is \code{2}, the maintenance window won't run until
two days later.}

\item{Duration}{[required] The duration of the maintenance window in hours.}

\item{Cutoff}{[required] The number of hours before the end of the maintenance window that Amazon
Web Services Systems Manager stops scheduling new tasks for execution.}

\item{AllowUnassociatedTargets}{[required] Enables a maintenance window task to run on managed nodes, even if you
haven't registered those nodes as targets. If enabled, then you must
specify the unregistered managed nodes (by node ID) when you register a
task with the maintenance window.

If you don't enable this option, then you must specify
previously-registered targets when you register a task with the
maintenance window.}

\item{ClientToken}{User-provided idempotency token.}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag a maintenance window to
identify the type of tasks it will run, the types of targets, and the
environment it will run in. In this case, you could specify the
following key-value pairs:
\itemize{
\item \verb{Key=TaskType,Value=AgentUpdate}
\item \verb{Key=OS,Value=Windows}
\item \verb{Key=Environment,Value=Production}
}

To add tags to an existing maintenance window, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} operation.}
}
\description{
Creates a new maintenance window.

See \url{https://www.paws-r-sdk.com/docs/ssm_create_maintenance_window/} for full documentation.
}
\keyword{internal}
