% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_detach_policy}
\alias{organizations_detach_policy}
\title{Detaches a policy from a target root, organizational unit (OU), or
account}
\usage{
organizations_detach_policy(PolicyId, TargetId)
}
\arguments{
\item{PolicyId}{[required] The unique identifier (ID) of the policy you want to detach. You can get
the ID from the \code{\link[=organizations_list_policies]{list_policies}} or
\code{\link[=organizations_list_policies_for_target]{list_policies_for_target}}
operations.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a policy ID
string requires "p-" followed by from 8 to 128 lowercase or uppercase
letters, digits, or the underscore character (_).}

\item{TargetId}{[required] The unique identifier (ID) of the root, OU, or account that you want to
detach the policy from. You can get the ID from the
\code{\link[=organizations_list_roots]{list_roots}},
\code{\link[=organizations_list_organizational_units_for_parent]{list_organizational_units_for_parent}},
or \code{\link[=organizations_list_accounts]{list_accounts}} operations.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a target ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with "r-" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Account} - A string that consists of exactly 12 digits.
\item \strong{Organizational unit (OU)} - A string that begins with "ou-"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second "-"
dash and from 8 to 32 additional lowercase letters or digits.
}}
}
\description{
Detaches a policy from a target root, organizational unit (OU), or account.

See \url{https://www.paws-r-sdk.com/docs/organizations_detach_policy/} for full documentation.
}
\keyword{internal}
