% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_create_instance}
\alias{opsworks_create_instance}
\title{Creates an instance in a specified stack}
\usage{
opsworks_create_instance(
  StackId,
  LayerIds,
  InstanceType,
  AutoScalingType = NULL,
  Hostname = NULL,
  Os = NULL,
  AmiId = NULL,
  SshKeyName = NULL,
  AvailabilityZone = NULL,
  VirtualizationType = NULL,
  SubnetId = NULL,
  Architecture = NULL,
  RootDeviceType = NULL,
  BlockDeviceMappings = NULL,
  InstallUpdatesOnBoot = NULL,
  EbsOptimized = NULL,
  AgentVersion = NULL,
  Tenancy = NULL
)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{LayerIds}{[required] An array that contains the instance's layer IDs.}

\item{InstanceType}{[required] The instance type, such as \code{t2.micro}. For a list of supported instance
types, open the stack in the console, choose \strong{Instances}, and choose
\strong{+ Instance}. The \strong{Size} list contains the currently supported
types. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Families and Types}.
The parameter values that you use to specify the various types are in
the \strong{API Name} column of the \strong{Available Instance Types} table.}

\item{AutoScalingType}{For load-based or time-based instances, the type. Windows stacks can use
only time-based instances.}

\item{Hostname}{The instance host name. The following are character limits for instance
host names.
\itemize{
\item Linux-based instances: 63 characters
\item Windows-based instances: 15 characters
}}

\item{Os}{The instance's operating system, which must be set to one of the
following.
\itemize{
\item A supported Linux operating system: An Amazon Linux version, such as
\verb{Amazon Linux 2}, \verb{Amazon Linux 2018.03}, \verb{Amazon Linux 2017.09},
\verb{Amazon Linux 2017.03}, \verb{Amazon Linux 2016.09},
\verb{Amazon Linux 2016.03}, \verb{Amazon Linux 2015.09}, or
\verb{Amazon Linux 2015.03}.
\item A supported Ubuntu operating system, such as \verb{Ubuntu 18.04 LTS},
\verb{Ubuntu 16.04 LTS}, \verb{Ubuntu 14.04 LTS}, or \verb{Ubuntu 12.04 LTS}.
\item \verb{CentOS Linux 7}
\item \verb{Red Hat Enterprise Linux 7}
\item A supported Windows operating system, such as
\verb{Microsoft Windows Server 2012 R2 Base},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Express},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Standard}, or
\verb{Microsoft Windows Server 2012 R2 with SQL Server Web}.
\item A custom AMI: \code{Custom}.
}

Not all operating systems are supported with all versions of Chef. For
more information about the supported operating systems, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html}{OpsWorks Stacks Operating Systems}.

The default option is the current Amazon Linux version. If you set this
parameter to \code{Custom}, you must use the
\code{\link[=opsworks_create_instance]{create_instance}} action's AmiId parameter
to specify the custom AMI that you want to use. Block device mappings
are not supported if the value is \code{Custom}. For more information about
how to use custom AMIs with OpsWorks Stacks, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html}{Using Custom AMIs}.}

\item{AmiId}{A custom AMI ID to be used to create the instance. The AMI should be
based on one of the supported operating systems. For more information,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html}{Using Custom AMIs}.

If you specify a custom AMI, you must set \code{Os} to \code{Custom}.}

\item{SshKeyName}{The instance's Amazon EC2 key-pair name.}

\item{AvailabilityZone}{The instance Availability Zone. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{Regions and Endpoints}.}

\item{VirtualizationType}{The instance's virtualization type, \code{paravirtual} or \code{hvm}.}

\item{SubnetId}{The ID of the instance's subnet. If the stack is running in a VPC, you
can use this parameter to override the stack's default subnet ID value
and direct OpsWorks Stacks to launch the instance in a different subnet.}

\item{Architecture}{The instance architecture. The default option is \code{x86_64}. Instance
types do not necessarily support both architectures. For a list of the
architectures that are supported by the different instance types, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Families and Types}.}

\item{RootDeviceType}{The instance root device type. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device}{Storage for the Root Device}.}

\item{BlockDeviceMappings}{An array of \code{BlockDeviceMapping} objects that specify the instance's
block devices. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html}{Block Device Mapping}.
Note that block device mappings are not supported for custom AMIs.}

\item{InstallUpdatesOnBoot}{Whether to install operating system and package updates when the
instance boots. The default value is \code{true}. To control when updates are
installed, set this value to \code{false}. You must then update your
instances manually by using
\code{\link[=opsworks_create_deployment]{create_deployment}} to run the
\code{update_dependencies} stack command or by manually running \code{yum} (Amazon
Linux) or \code{apt-get} (Ubuntu) on the instances.

We strongly recommend using the default value of \code{true} to ensure that
your instances have the latest security updates.}

\item{EbsOptimized}{Whether to create an Amazon EBS-optimized instance.}

\item{AgentVersion}{The default OpsWorks Stacks agent version. You have the following
options:
\itemize{
\item \code{INHERIT} - Use the stack's default agent version setting.
\item \emph{version_number} - Use the specified agent version. This value
overrides the stack's default setting. To update the agent version,
edit the instance configuration and specify a new version. OpsWorks
Stacks installs that version on the instance.
}

The default setting is \code{INHERIT}. To specify an agent version, you must
use the complete version number, not the abbreviated number shown on the
console. For a list of available agent version numbers, call
\code{\link[=opsworks_describe_agent_versions]{describe_agent_versions}}.
AgentVersion cannot be set to Chef 12.2.}

\item{Tenancy}{The instance's tenancy option. The default option is no tenancy, or if
the instance is running in a VPC, inherit tenancy settings from the VPC.
The following are valid values for this parameter: \code{dedicated},
\code{default}, or \code{host}. Because there are costs associated with changes in
tenancy options, we recommend that you research tenancy options before
choosing them for your instances. For more information about dedicated
hosts, see \href{https://aws.amazon.com/ec2/dedicated-hosts/}{Dedicated Hosts Overview} and \href{https://aws.amazon.com/ec2/dedicated-hosts/}{Amazon EC2 Dedicated Hosts}. For more
information about dedicated instances, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/}{Dedicated Instances} and
\href{https://aws.amazon.com/ec2/pricing/dedicated-instances/}{Amazon EC2 Dedicated Instances}.}
}
\description{
Creates an instance in a specified stack. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html}{Adding an Instance to a Layer}.

See \url{https://www.paws-r-sdk.com/docs/opsworks_create_instance/} for full documentation.
}
\keyword{internal}
