% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanagerlinuxsubscriptions_service.R
\name{licensemanagerlinuxsubscriptions}
\alias{licensemanagerlinuxsubscriptions}
\title{AWS License Manager Linux Subscriptions}
\usage{
licensemanagerlinuxsubscriptions(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
With License Manager, you can discover and track your commercial Linux
subscriptions on running Amazon EC2 instances.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- licensemanagerlinuxsubscriptions(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=licensemanagerlinuxsubscriptions_deregister_subscription_provider]{deregister_subscription_provider} \tab Remove a third-party subscription provider from the Bring Your Own License (BYOL) subscriptions registered to your account\cr
\link[=licensemanagerlinuxsubscriptions_get_registered_subscription_provider]{get_registered_subscription_provider} \tab Get details for a Bring Your Own License (BYOL) subscription that's registered to your account\cr
\link[=licensemanagerlinuxsubscriptions_get_service_settings]{get_service_settings} \tab Lists the Linux subscriptions service settings for your account\cr
\link[=licensemanagerlinuxsubscriptions_list_linux_subscription_instances]{list_linux_subscription_instances} \tab Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions\cr
\link[=licensemanagerlinuxsubscriptions_list_linux_subscriptions]{list_linux_subscriptions} \tab Lists the Linux subscriptions that have been discovered\cr
\link[=licensemanagerlinuxsubscriptions_list_registered_subscription_providers]{list_registered_subscription_providers} \tab List Bring Your Own License (BYOL) subscription registration resources for your account\cr
\link[=licensemanagerlinuxsubscriptions_list_tags_for_resource]{list_tags_for_resource} \tab List the metadata tags that are assigned to the specified Amazon Web Services resource\cr
\link[=licensemanagerlinuxsubscriptions_register_subscription_provider]{register_subscription_provider} \tab Register the supported third-party subscription provider for your Bring Your Own License (BYOL) subscription\cr
\link[=licensemanagerlinuxsubscriptions_tag_resource]{tag_resource} \tab Add metadata tags to the specified Amazon Web Services resource\cr
\link[=licensemanagerlinuxsubscriptions_untag_resource]{untag_resource} \tab Remove one or more metadata tag from the specified Amazon Web Services resource\cr
\link[=licensemanagerlinuxsubscriptions_update_service_settings]{update_service_settings} \tab Updates the service settings for Linux subscriptions
}
}

\examples{
\dontrun{
svc <- licensemanagerlinuxsubscriptions()
svc$deregister_subscription_provider(
  Foo = 123
)
}

}
