% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_update_log_anomaly_detector}
\alias{cloudwatchlogs_update_log_anomaly_detector}
\title{Updates an existing log anomaly detector}
\usage{
cloudwatchlogs_update_log_anomaly_detector(
  anomalyDetectorArn,
  evaluationFrequency = NULL,
  filterPattern = NULL,
  anomalyVisibilityTime = NULL,
  enabled
)
}
\arguments{
\item{anomalyDetectorArn}{[required] The ARN of the anomaly detector that you want to update.}

\item{evaluationFrequency}{Specifies how often the anomaly detector runs and look for anomalies.
Set this value according to the frequency that the log group receives
new logs. For example, if the log group receives new log events every 10
minutes, then setting \code{evaluationFrequency} to \code{FIFTEEN_MIN} might be
appropriate.}

\item{filterPattern}{}

\item{anomalyVisibilityTime}{The number of days to use as the life cycle of anomalies. After this
time, anomalies are automatically baselined and the anomaly detector
model will treat new occurrences of similar event as normal. Therefore,
if you do not correct the cause of an anomaly during this time, it will
be considered normal going forward and will not be detected.}

\item{enabled}{[required] Use this parameter to pause or restart the anomaly detector.}
}
\description{
Updates an existing log anomaly detector.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_update_log_anomaly_detector/} for full documentation.
}
\keyword{internal}
