% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchinternetmonitor_operations.R
\name{cloudwatchinternetmonitor_get_query_results}
\alias{cloudwatchinternetmonitor_get_query_results}
\title{Return the data for a query with the Amazon CloudWatch Internet Monitor
query interface}
\usage{
cloudwatchinternetmonitor_get_query_results(
  MonitorName,
  QueryId,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{MonitorName}{[required] The name of the monitor to return data for.}

\item{QueryId}{[required] The ID of the query that you want to return data results for. A
\code{QueryId} is an internally-generated identifier for a specific query.}

\item{NextToken}{The token for the next set of results. You receive this token from a
previous call.}

\item{MaxResults}{The number of query results that you want to return with this call.}
}
\description{
Return the data for a query with the Amazon CloudWatch Internet Monitor query interface. Specify the query that you want to return results for by providing a \code{QueryId} and a monitor name.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_query_results/} for full documentation.
}
\keyword{internal}
