% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchapplicationsignals_operations.R
\name{cloudwatchapplicationsignals_list_services}
\alias{cloudwatchapplicationsignals_list_services}
\title{Returns a list of services that have been discovered by Application
Signals}
\usage{
cloudwatchapplicationsignals_list_services(
  StartTime,
  EndTime,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{StartTime}{[required] The start of the time period to retrieve information about. When used in
a raw HTTP Query API, it is formatted as be epoch time in seconds. For
example: \code{1698778057}

Your requested start time will be rounded to the nearest hour.}

\item{EndTime}{[required] The end of the time period to retrieve information about. When used in a
raw HTTP Query API, it is formatted as be epoch time in seconds. For
example: \code{1698778057}

Your requested start time will be rounded to the nearest hour.}

\item{MaxResults}{The maximum number of results to return in one operation. If you omit
this parameter, the default of 50 is used.}

\item{NextToken}{Include this value, if it was returned by the previous operation, to get
the next set of services.}
}
\description{
Returns a list of services that have been discovered by Application Signals. A service represents a minimum logical and transactional unit that completes a business function. Services are discovered through Application Signals instrumentation.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_services/} for full documentation.
}
\keyword{internal}
