% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_enable_federation}
\alias{cloudtrail_enable_federation}
\title{Enables Lake query federation on the specified event data store}
\usage{
cloudtrail_enable_federation(EventDataStore, FederationRoleArn)
}
\arguments{
\item{EventDataStore}{[required] The ARN (or ID suffix of the ARN) of the event data store for which you
want to enable Lake query federation.}

\item{FederationRoleArn}{[required] The ARN of the federation role to use for the event data store. Amazon
Web Services services like Lake Formation use this federation role to
access data for the federated event data store. The federation role must
exist in your account and provide the \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role}{required minimum permissions}.}
}
\description{
Enables Lake query federation on the specified event data store. Federating an event data store lets you view the metadata associated with the event data store in the Glue \href{https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro}{Data Catalog} and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_enable_federation/} for full documentation.
}
\keyword{internal}
