% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagentruntime_operations.R
\name{bedrockagentruntime_invoke_flow}
\alias{bedrockagentruntime_invoke_flow}
\title{Invokes an alias of a flow to run the inputs that you specify and return
the output of each node as a stream}
\usage{
bedrockagentruntime_invoke_flow(
  enableTrace = NULL,
  executionId = NULL,
  flowAliasIdentifier,
  flowIdentifier,
  inputs,
  modelPerformanceConfiguration = NULL
)
}
\arguments{
\item{enableTrace}{Specifies whether to return the trace for the flow or not. Traces track
inputs and outputs for nodes in the flow. For more information, see
\href{https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html}{Track each step in your prompt flow by viewing its trace in Amazon Bedrock}.}

\item{executionId}{The unique identifier for the current flow execution. If you don't
provide a value, Amazon Bedrock creates the identifier for you.}

\item{flowAliasIdentifier}{[required] The unique identifier of the flow alias.}

\item{flowIdentifier}{[required] The unique identifier of the flow.}

\item{inputs}{[required] A list of objects, each containing information about an input into the
flow.}

\item{modelPerformanceConfiguration}{Model performance settings for the request.}
}
\description{
Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If there's an error, the error is returned. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html}{Test a flow in Amazon Bedrock} in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.

See \url{https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_flow/} for full documentation.
}
\keyword{internal}
