% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatbot_service.R
\name{chatbot}
\alias{chatbot}
\title{AWS Chatbot}
\usage{
chatbot(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The \emph{AWS Chatbot API Reference} provides descriptions, API request
parameters, and the XML response for each of the AWS Chatbot API
actions.

AWS Chatbot APIs are currently available in the following Regions:
\itemize{
\item US East (Ohio) - \code{us-east-2}
\item US West (Oregon) - \code{us-west-2}
\item Asia Pacific (Singapore) - \code{ap-southeast-1}
\item Europe (Ireland) - \code{eu-west-1}
}

The AWS Chatbot console can only be used in US East (Ohio). Your
configuration data however, is stored in each of the relevant available
Regions.

Your AWS CloudTrail events are logged in whatever Region you call from,
not US East (N. Virginia) by default.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- chatbot(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=chatbot_associate_to_configuration]{associate_to_configuration} \tab Links a resource (for example, a custom action) to a channel configuration\cr
\link[=chatbot_create_chime_webhook_configuration]{create_chime_webhook_configuration} \tab Creates an AWS Chatbot configuration for Amazon Chime\cr
\link[=chatbot_create_custom_action]{create_custom_action} \tab Creates a custom action that can be invoked as an alias or as a button on a notification\cr
\link[=chatbot_create_microsoft_teams_channel_configuration]{create_microsoft_teams_channel_configuration} \tab Creates an AWS Chatbot configuration for Microsoft Teams\cr
\link[=chatbot_create_slack_channel_configuration]{create_slack_channel_configuration} \tab Creates an AWS Chatbot confugration for Slack\cr
\link[=chatbot_delete_chime_webhook_configuration]{delete_chime_webhook_configuration} \tab Deletes a Amazon Chime webhook configuration for AWS Chatbot\cr
\link[=chatbot_delete_custom_action]{delete_custom_action} \tab Deletes a custom action\cr
\link[=chatbot_delete_microsoft_teams_channel_configuration]{delete_microsoft_teams_channel_configuration} \tab Deletes a Microsoft Teams channel configuration for AWS Chatbot\cr
\link[=chatbot_delete_microsoft_teams_configured_team]{delete_microsoft_teams_configured_team} \tab Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams team\cr
\link[=chatbot_delete_microsoft_teams_user_identity]{delete_microsoft_teams_user_identity} \tab Identifes a user level permission for a channel configuration\cr
\link[=chatbot_delete_slack_channel_configuration]{delete_slack_channel_configuration} \tab Deletes a Slack channel configuration for AWS Chatbot\cr
\link[=chatbot_delete_slack_user_identity]{delete_slack_user_identity} \tab Deletes a user level permission for a Slack channel configuration\cr
\link[=chatbot_delete_slack_workspace_authorization]{delete_slack_workspace_authorization} \tab Deletes the Slack workspace authorization that allows channels to be configured in that workspace\cr
\link[=chatbot_describe_chime_webhook_configurations]{describe_chime_webhook_configurations} \tab Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn\cr
\link[=chatbot_describe_slack_channel_configurations]{describe_slack_channel_configurations} \tab Lists Slack channel configurations optionally filtered by ChatConfigurationArn\cr
\link[=chatbot_describe_slack_user_identities]{describe_slack_user_identities} \tab Lists all Slack user identities with a mapped role\cr
\link[=chatbot_describe_slack_workspaces]{describe_slack_workspaces} \tab List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot\cr
\link[=chatbot_disassociate_from_configuration]{disassociate_from_configuration} \tab Unlink a resource, for example a custom action, from a channel configuration\cr
\link[=chatbot_get_account_preferences]{get_account_preferences} \tab Returns AWS Chatbot account preferences\cr
\link[=chatbot_get_custom_action]{get_custom_action} \tab Returns a custom action\cr
\link[=chatbot_get_microsoft_teams_channel_configuration]{get_microsoft_teams_channel_configuration} \tab Returns a Microsoft Teams channel configuration in an AWS account\cr
\link[=chatbot_list_associations]{list_associations} \tab Lists resources associated with a channel configuration\cr
\link[=chatbot_list_custom_actions]{list_custom_actions} \tab Lists custom actions defined in this account\cr
\link[=chatbot_list_microsoft_teams_channel_configurations]{list_microsoft_teams_channel_configurations} \tab Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account\cr
\link[=chatbot_list_microsoft_teams_configured_teams]{list_microsoft_teams_configured_teams} \tab Lists all authorized Microsoft Teams for an AWS Account\cr
\link[=chatbot_list_microsoft_teams_user_identities]{list_microsoft_teams_user_identities} \tab A list all Microsoft Teams user identities with a mapped role\cr
\link[=chatbot_list_tags_for_resource]{list_tags_for_resource} \tab Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify\cr
\link[=chatbot_tag_resource]{tag_resource} \tab Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN)\cr
\link[=chatbot_untag_resource]{untag_resource} \tab Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN)\cr
\link[=chatbot_update_account_preferences]{update_account_preferences} \tab Updates AWS Chatbot account preferences\cr
\link[=chatbot_update_chime_webhook_configuration]{update_chime_webhook_configuration} \tab Updates a Amazon Chime webhook configuration\cr
\link[=chatbot_update_custom_action]{update_custom_action} \tab Updates a custom action\cr
\link[=chatbot_update_microsoft_teams_channel_configuration]{update_microsoft_teams_channel_configuration} \tab Updates an Microsoft Teams channel configuration\cr
\link[=chatbot_update_slack_channel_configuration]{update_slack_channel_configuration} \tab Updates a Slack channel configuration
}
}

\examples{
\dontrun{
svc <- chatbot()
svc$associate_to_configuration(
  Foo = 123
)
}

}
