% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographycontrolplane_operations.R
\name{paymentcryptographycontrolplane_get_parameters_for_export}
\alias{paymentcryptographycontrolplane_get_parameters_for_export}
\title{Gets the export token and the signing key certificate to initiate a
TR-34 key export from Amazon Web Services Payment Cryptography}
\usage{
paymentcryptographycontrolplane_get_parameters_for_export(
  KeyMaterialType,
  SigningKeyAlgorithm
)
}
\arguments{
\item{KeyMaterialType}{[required] The key block format type (for example, TR-34 or TR-31) to use during
key material export. Export token is only required for a TR-34 key
export, \code{TR34_KEY_BLOCK}. Export token is not required for TR-31 key
export.}

\item{SigningKeyAlgorithm}{[required] The signing key algorithm to generate a signing key certificate. This
certificate signs the wrapped key under export within the TR-34 key
block. \code{RSA_2048} is the only signing key algorithm allowed.}
}
\description{
Gets the export token and the signing key certificate to initiate a TR-34 key export from Amazon Web Services Payment Cryptography.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_get_parameters_for_export/} for full documentation.
}
\keyword{internal}
